#include "dayperiod.h"
#include <iostream>
using namespace std;

DayPeriod::DayPeriod(int day)
{
    dayNum = day;
    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
             this, SLOT(requestFinished(QNetworkReply*)));

    listItem = new QListWidgetItem();
    listItem->setTextAlignment(Qt::AlignHCenter);

}

DayPeriod::~DayPeriod(){
    delete listItem;
    delete manager;
}

void DayPeriod::setInfo(QString &title, QString &condition, QString &temperature, QString &iconURL){
    this->listItem->setText(title + "\n" + condition + "\n" + temperature);
    manager->get(QNetworkRequest(QUrl(iconURL)));
}

void DayPeriod::requestFinished(QNetworkReply *reply){
    QPixmap pix;
    pix.loadFromData(reply->readAll());

    QIcon icn(pix);


    listItem->setIcon(icn);
    reply->deleteLater();
}

void DayPeriod::setLoading(){
    listItem->setIcon(QIcon(":/loading.png"));
}
