#ifndef STACKEDWINDOW_H
#define STACKEDWINDOW_H

#include <QMainWindow>
#include "commonIncludes.h"

namespace Ui {
    class StackedWindow;
}

class StackedWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit StackedWindow(QString latlong, QString wso, QString zcode, QString offset, QString &dayIcon, QString &nightIcon, QWidget *parent = 0);
    ~StackedWindow();
    void setInfo(QString &day, QString &hi, QString &lo, QString &precip, QString &dayFor, QString &nightFor);

protected:
    virtual void resizeEvent(QResizeEvent * event);

public slots:
    void loadLabel(QNetworkReply *reply);
    void loadPrecip(QNetworkReply *reply);
    void loadDayIcon(QNetworkReply *reply);
    void loadNightIcon(QNetworkReply *reply);

private:
    Ui::StackedWindow *ui;
    QNetworkAccessManager *manager;
    QNetworkAccessManager *manager2;
    QNetworkAccessManager *manager3;
    QNetworkAccessManager *manager4;
};

#endif // STACKEDWINDOW_H
