#include "stackedwindow.h"
#include "ui_stackedwindow.h"


using namespace std;

StackedWindow::StackedWindow(QString latlong, QString wfo, QString zcode, QString offset, QString &dayIcon, QString &nightIcon, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::StackedWindow)
{


    zcode = "MEZ015"; // delete this line once we find a way to get the zcode

    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
             this, SLOT(loadLabel(QNetworkReply*)));
    manager->get(QNetworkRequest(QUrl("http://forecast.weather.gov/wtf/meteograms/Plotter.php?" + latlong + "&wfo=" + wfo + "&zcode=" + zcode + "&gset=20&gdiff=10&unit=0&tinfo=EY5&ahour=" + offset +"&pcmd=100100000000000000000000000000000000000000000000&lg=en&indu=1!1!1&dd=0&bw=0&hrspan=48&pqpfhr=6")));


    manager2 = new QNetworkAccessManager(this);
    connect(manager2, SIGNAL(finished(QNetworkReply*)),
             this, SLOT(loadPrecip(QNetworkReply*)));
    manager2->get(QNetworkRequest(QUrl("http://forecast.weather.gov/wtf/meteograms/Plotter.php?" + latlong + "&wfo=" + wfo + "&zcode=" + zcode + "&gset=20&gdiff=10&unit=0&tinfo=EY5&ahour=0&pcmd=000000110000000000000000000000000000000000000000&lg=en&indu=1!1!1&dd=0&bw=0&hrspan=48&pqpfhr=6")));

    manager3 = new QNetworkAccessManager(this);
    connect(manager3, SIGNAL(finished(QNetworkReply*)),
             this, SLOT(loadDayIcon(QNetworkReply*)));
    manager3->get(QNetworkRequest(QUrl(dayIcon)));

    manager4 = new QNetworkAccessManager(this);
    connect(manager4, SIGNAL(finished(QNetworkReply*)),
             this, SLOT(loadNightIcon(QNetworkReply*)));
    manager4->get(QNetworkRequest(QUrl(nightIcon)));

    ui->setupUi(this);

}

StackedWindow::~StackedWindow()
{
    delete ui;
    delete manager;
    delete manager2;
    delete manager3;
    delete manager4;
}


void StackedWindow::setInfo(QString &day, QString &hi, QString &lo,
                            QString &precip, QString &dayFor, QString &nightFor){

    ui->dayIcon->setPixmap(QPixmap(":/loading.png"));
    ui->nightIcon->setPixmap(QPixmap(":/loading.png"));
    ui->tempGraph->setScaledContents(false);
    ui->tempGraph->setAlignment(Qt::AlignHCenter);
    ui->tempGraph->setPixmap(QPixmap(":/loading.png"));
    ui->precipGraph->setScaledContents(false);
    ui->precipGraph->setAlignment(Qt::AlignHCenter);
    ui->precipGraph->setPixmap(QPixmap(":/loading.png"));

    ui->day->setText(day);
    ui->hi->setText(hi);
    ui->lo->setText(lo);
    ui->precip->setText(precip);
    ui->dayForecast->setText(dayFor);
    ui->nightForecast->setText(nightFor);

    ui->label->setPalette(QApplication::palette().highlight().color());
    ui->label_2->setPalette(QApplication::palette().highlight().color());
    ui->label_3->setPalette(QApplication::palette().highlight().color());
}

void StackedWindow::loadLabel(QNetworkReply *reply){
    QPixmap pix;
    pix.loadFromData(reply->readAll());
    ui->tempGraph->setScaledContents(true);
    ui->tempGraph->setPixmap(pix);
    reply->deleteLater();
}

void StackedWindow::loadPrecip(QNetworkReply *reply){
    QPixmap pix;
    pix.loadFromData(reply->readAll());
    ui->precipGraph->setScaledContents(true);
    ui->precipGraph->setPixmap(pix);
    reply->deleteLater();
}

void StackedWindow::loadDayIcon(QNetworkReply *reply){
    QPixmap pix;
    pix.loadFromData(reply->readAll());
    ui->dayIcon->setPixmap(pix);
    reply->deleteLater();
}

void StackedWindow::loadNightIcon(QNetworkReply *reply){
    QPixmap pix;
    pix.loadFromData(reply->readAll());
    ui->nightIcon->setPixmap(pix);
    reply->deleteLater();
}

void StackedWindow::resizeEvent(QResizeEvent *event){
    if(event->oldSize().width() > event->size().width()){
        ui->frame->setMinimumWidth(100);
    }else{
        ui->frame->setMinimumWidth(720);
    }

}
