import QtQuick 1.0

Rectangle {
	property alias tempurl: tempFrame.graphurl
	property alias windurl: windFrame.graphurl
	property alias precipurl: precipFrame.graphurl
	property alias rainurl: rainFrame.graphurl
	property alias snowurl: snowFrame.graphurl

	property int basey: 100
	property int graphy: -20

	id: graphPanel
	width: 800
	height: 320
//	width: parent.width
//	height: parent.height
	color: "#00000000"

 GraphFrame {
	id: graphFrame
	x: 0; y: basey; z: 1
	switchable: false
	iconurl: "images/graph.png"
 }

 MouseArea {
	 id: graphArea
	 x: 350; y: basey+75
	 width: 100; height: 100
	 onClicked:{
		 if(graphPanel.state == "display")
			 graphPanel.state = ""
		 else
			 graphPanel.state = "display"
	 }
 }

 GraphFrame {
	id: tempFrame
	x: 0; y: basey; z: 0
	opacity: 0
	switchable: false
	iconurl: "images/temp.png"

	 MouseArea {
		 id: tempArea
		anchors.rightMargin: 350
		anchors.leftMargin: 350
		anchors.bottomMargin: 75
		anchors.topMargin: 75
		anchors.fill: parent
		onClicked: graphPanel.state = "tempDisplay"
	 }
 }

 GraphFrame {
	 id: windFrame
	 x: 0
	 y: basey
  opacity: 0
  switchable: false
  iconurl: "images/wind.png"

  MouseArea {
	  id: windArea
	anchors.rightMargin: 350
	anchors.leftMargin: 350
	anchors.bottomMargin: 75
	anchors.topMargin: 75
	anchors.fill: parent
	onClicked: graphPanel.state = "windDisplay"
  }
 }

 GraphFrame {
	 id: precipFrame
	 x: 0
	 y: basey
	  opacity: 0
	  switchable: false
	  iconurl: "images/precip.png"

  MouseArea {
	  id: precipArea
	   anchors.rightMargin: 350
	   anchors.leftMargin: 350
	   anchors.bottomMargin: 75
	   anchors.topMargin: 75
	   anchors.fill: parent
	   onClicked: graphPanel.state = "precipDisplay"
  }
 }

 GraphFrame {
	 id: rainFrame
	 x: 0
	 y: basey
  opacity: 0
  switchable: false
  iconurl: "images/rain.png"

  MouseArea {
	  id: rainArea
	   anchors.rightMargin: 350
	   anchors.leftMargin: 350
	   anchors.bottomMargin: 75
	   anchors.topMargin: 75
	   anchors.fill: parent
	   onClicked: graphPanel.state = "rainDisplay"
  }
 }

 GraphFrame {
	 id: snowFrame
	 x: 0
	 y: basey
  opacity: 0
  switchable: false
  iconurl: "images/snow.png"

  MouseArea {
	  id: snowArea
	   anchors.bottomMargin: 75
	   anchors.rightMargin: 350
	   anchors.leftMargin: 350
	   anchors.topMargin: 75
	   anchors.fill: parent
		  z: 1
		  onClicked: graphPanel.state = "snowDisplay"
  }
 }

 Rectangle {
	id: background
	width: 12000
	height: 12000
	color: "#000000"
	anchors.centerIn: parent
	opacity: 0

	 Behavior on opacity {
		 NumberAnimation {duration: 500}
	 }
 }


 states: [
	 State {
		 name: "display"
		PropertyChanges {target: graphFrame;opacity: 0}
		PropertyChanges {target: tempFrame; x: -300; y: 140 ;opacity: 1; z: 1}
		PropertyChanges {target: windFrame; x: -150; y: 140; opacity: 1; z: 1}
		PropertyChanges {target: precipFrame;y: 140; opacity: 1 ; z: 1}
		PropertyChanges {target: rainFrame; x: 150; y: 140; opacity: 1; z: 1}
		PropertyChanges {target: snowFrame; x: 300; y: 140; opacity: 1; z: 1}
		PropertyChanges {target: background; z: -1; opacity: 0.8}
		PropertyChanges {target: tempArea; z: 2}
		PropertyChanges {target: graphArea; x: 0; y: 0; width: 800; height: 320; z: 1}
		},
	 State {
		name: "tempDisplay"
		PropertyChanges {target: graphFrame; opacity: 0}
		PropertyChanges {target: tempFrame; x: 0; y: graphy; opacity: 1; z: 2; switchable: true; state: "graph"}
		PropertyChanges {target: windFrame; x: -150; y: 140; opacity: 1}
		PropertyChanges {target: precipFrame; y: 140; opacity: 1}
		PropertyChanges {target: rainFrame; x: 150; y: 140; opacity: 1}
		PropertyChanges {target: snowFrame; x: 300; y: 140; opacity: 1}
		PropertyChanges {target: background; z: -1; opacity: 0.8}
		PropertyChanges {target: tempArea; z: -1}
		PropertyChanges {target: graphArea; x: 0; y: 0; width: 800; height: 320; z: 0}
		},
	 State {
		name: "windDisplay"
		PropertyChanges {target: graphFrame; opacity: 0}
		PropertyChanges {target: tempFrame;x: -300;y: 140; opacity: 1; z: 1}
		PropertyChanges {target: windFrame;x: 0;y: graphy; z: 2;switchable: true;opacity: 1; state: "graph"}
		PropertyChanges {target: precipFrame;y: 140;opacity: 1}
		PropertyChanges {target: rainFrame;x: 150;y: 140; opacity: 1}
		PropertyChanges {target: snowFrame;x: 300;y: 140; opacity: 1}
		PropertyChanges {target: background;z: -1;opacity: 0.8}
		PropertyChanges {target: windArea;z: -1}
		PropertyChanges {target: graphArea ;x: 0; y: 0; width: 800; height: 320; z: 0}
		},
	 State {
		name: "precipDisplay"
		PropertyChanges {target: graphFrame; opacity: 0}
		PropertyChanges {target: tempFrame;x: -300;y: 140; opacity: 1; z: 1}
		PropertyChanges {target: windFrame; x: -150; y: 140; opacity: 1}
		PropertyChanges {target: precipFrame; x: 0; y: graphy; z: 2; opacity: 1; switchable: true; state: "graph"}
		PropertyChanges {target: rainFrame;x: 150;y: 140; opacity: 1}
		PropertyChanges {target: snowFrame;x: 300;y: 140; opacity: 1}
		PropertyChanges {target: background;z: -1;opacity: 0.8}
		PropertyChanges {target: precipArea;z: -1}
		PropertyChanges {target: graphArea ;x: 0; y: 0; width: 800; height: 320; z: 0}
		},
	 State {
		name: "rainDisplay"
		PropertyChanges {target: graphFrame; opacity: 0}
		PropertyChanges {target: tempFrame;x: -300;y: 140; opacity: 1; z: 1}
		PropertyChanges {target: windFrame; x: -150; y: 140; opacity: 1}
		PropertyChanges {target: precipFrame;y: 140;opacity: 1}
		PropertyChanges {target: rainFrame;x: 0;y: graphy; z: 2; opacity: 1; switchable: true; state: "graph"}
		PropertyChanges {target: snowFrame;x: 300;y: 140; opacity: 1}
		PropertyChanges {target: background;z: -1;opacity: 0.8}
		PropertyChanges {target: rainArea;z: -1}
		PropertyChanges {target: graphArea ;x: 0; y: 0; width: 800; height: 320; z: 0}
		},
	 State {
		name: "snowDisplay"
		PropertyChanges {target: graphFrame; opacity: 0}
		PropertyChanges {target: tempFrame;x: -300;y: 140; opacity: 1; z: 1}
		PropertyChanges {target: windFrame; x: -150; y: 140; opacity: 1}
		PropertyChanges {target: precipFrame;y: 140;opacity: 1}
		PropertyChanges {target: rainFrame;x: 150;y: 140; opacity: 1}
		PropertyChanges {target: snowFrame;x: 0;y: graphy; z: 2; opacity: 1; switchable: true; state: "graph"}
		PropertyChanges {target: background;z: -1;opacity: 0.8}
		PropertyChanges {target: snowArea;z: -1}
		PropertyChanges {target: graphArea ;x: 0; y: 0; width: 800; height: 320; z: 0}
		}



 ]




}
