import QtQuick 1.0

Rectangle {

	property string icon: "images/loading.png"
	property string wordedForecast
	property string temperature
	property string precipitation
	property string cond

	property alias tempurl: graphPanel.tempurl
	property alias windurl: graphPanel.windurl
	property alias precipurl: graphPanel.precipurl
	property alias rainurl: graphPanel.rainurl
	property alias snowurl: graphPanel.snowurl




	id: detailView
	width: parent.width
	height: parent.height
	color: "#00000000"

	GraphPanel {
		id: graphPanel
		x: 0
		y: 0
  anchors.bottom: parent.bottom
  anchors.bottomMargin: 80
  anchors.horizontalCenter: parent.horizontalCenter
		z:1

	}

	Image {
		id: img
		width: 100
		height: 100
		anchors.left: parent.left
		anchors.leftMargin: 10
		anchors.top: parent.top
		anchors.topMargin: 10
		source: icon
	}

	Text {
		id: forecastText
		height: 20
		color: "#ffffff"
		text: wordedForecast
		anchors.top: parent.top
		anchors.topMargin: 10
		anchors.left: parent.left
		anchors.leftMargin: 150
		anchors.right: parent.right
		anchors.rightMargin: 20
		styleColor: "#ffffff"
		wrapMode: Text.WordWrap
		opacity: 1
		font.pixelSize: 20
	}

 Rectangle {
	 id: rectangle2
	 width: 100
	 height: 95
	 color: "#00ffffff"
	 anchors.top: parent.top
	 anchors.topMargin: 120
	 anchors.left: parent.left
	 anchors.leftMargin: 0

	 Text {
		 id: tempText
		 width: 80
		 height: 20
		 color: "#ffffff"
		 text: temperature
		anchors.top: parent.top
		anchors.topMargin: 0
		 anchors.left: parent.left
		 anchors.leftMargin: 10
		 font.pixelSize: 20
	 }

	 Text {
		 id: precipText
	   x: 10
	   y: 55
		 width: 80
		 height: 20
		 color: "#ffffff"
		 text: precipitation
	   anchors.top: parent.top
	   anchors.topMargin: 54
		 anchors.left: parent.left
		 anchors.leftMargin: 10
		 font.pixelSize: 20
	 }

	 Text {
		 id: conditionText
	   x: 10
	   y: 27

		 width: 80
		 height: 20
		 color: "#ffffff"
		 text: cond
   z: 0
		anchors.top: parent.top
	   anchors.topMargin: 28
		 anchors.left: parent.left
		 anchors.leftMargin: 10
	 font.pixelSize: 20
	}


 }



 MouseArea {
	 id: graphArea
	 x: 350
	 y: 160
	 width: 100
	 height: 100
  anchors.horizontalCenter: parent.horizontalCenter
//  z: 24
	 onClicked:{
		 if(detailView.state == "showGraphs")
			detailView.state = ""
		else{
			 detailView.state = "showGraphs"
		 }

	 }
 }


 states: [
	 State {
		 name: "showGraphs"

		 PropertyChanges {
			 target: graphArea
			 x: 0
			 y: 0
			 width: 800
			 height: 320
		 }
		 PropertyChanges{
			 target: graphPanel
			 state: "showGraphs"
		 }

	 }
 ]


}
