import QtQuick 1.0

Rectangle {
	property alias text: entryLabel.text
	property alias entryPlaceholder: entry.text
	property alias borderColor: entryBorder.color
	property alias focusEntry: entry.focus

	signal accepted()



	id: zipcodeField
	x: 0
	y: 0
	width: 604
	height: 52
	color: "#00ffffff"
	anchors.centerIn: parent
	opacity: 0

	Rectangle {
		id: entryBorder
		x: 346
		y: -1
		width: 259
		height: 54
		color: "#00ffffff"
		radius: 8
		anchors.top: parent.top
		border.color: "#180091"
		anchors.topMargin: 0

		TextInput {
			id: entry
			color: "#ffffff"
			smooth: false
			font.pixelSize: 40
			anchors.fill: parent
			horizontalAlignment: TextInput.AlignHCenter
			validator: RegExpValidator{regExp: /[0-9][0-9][0-9][0-9][0-9]/}
			Connections{
				onAccepted:{
					zipcodeField.accepted()
					entry.text = ""
				}

			}
		}
		anchors.bottom: parent.bottom
		anchors.rightMargin: 0
		border.width: 3
		anchors.bottomMargin: 0
		anchors.right: parent.right
	}

	Text {
		id: entryLabel
		color: "#ffffff"
		anchors.left: parent.left
		anchors.leftMargin: 0
		anchors.bottom: parent.bottom
		anchors.bottomMargin: 0
		anchors.top: parent.top
		anchors.topMargin: 2
		font.pixelSize: 40
	}
 states: [
	 State {
		 name: "portrait"

		 PropertyChanges {
			 target: zipcodeField
			 width: 259
			 height: 104
		 }

		 PropertyChanges {
			 target: entryBorder
			 anchors.topMargin: 52
		 }


	 }
 ]
}
