import QtQuick 1.0

Rectangle {

	id: mainwindow
	width: 800
	height: 480
	color: "#00000000"
	border.color: "#000000"
	state: "loading"
	Component.onCompleted: startUp.start()


	/**
	  Loads the users default home and zipcode from settings on startup
	  */
	function loadHome(){
		if(Utilities.defaultHome() == 1){
			mainwindow.state = "loading"
			home1Model.source = "http://umcs.maine.edu/~naddeoa/?zipcode=" + Utilities.home1()
		}else if(Utilities.defaultHome() == 2){
			mainwindow.state = "loading"
			home2Model.source = "http://umcs.maine.edu/~naddeoa/?zipcode=" + Utilities.home2()
		}else{
			mainwindow.state = "getZip"
		}
	}

	Timer{
		id: startUp
		onTriggered: loadHome()
	}


	XMLmodel{
		id:model
		onStatusChanged: {
			if(status == XmlListModel.Ready && mainwindow.state == "loading"){
				mainwindow.state = "Landscape"
				days.model.reload()
			}
		}

	}

	XMLmodel{
		id: home1Model
		onStatusChanged: {
			if(status == XmlListModel.Ready && mainwindow.state == "loading"){
				mainwindow.state = "home1"
				days.model.reload()
			}
		}


	}

	XMLmodel{
		id: home2Model
		onStatusChanged: {
			if(status == XmlListModel.Ready && mainwindow.state == "loading"){
				mainwindow.state = "home2"
				days.model.reload()
			}
		}


	}



	ListView {
		property int upValue: 385
		property int downValue: 480

		id: days
		x: 0
		y: 480
		z:10
		height: 85
		anchors.right: parent.right
		anchors.rightMargin: 0
		anchors.left: parent.left
		anchors.leftMargin: 0
		opacity: 0
		currentIndex: 0
		visible: true
		orientation: ListView.Horizontal
		boundsBehavior: Flickable.StopAtBounds
		delegate:XMLDayDelegate{
			id: delegate
			function setBackground(){
				if(Utilities.substr(wordedForecast, "now") ){
					background.state = "snowyDay"
				}else if(Utilities.substr(wordedForecast, "ain") || Utilities.substr(forecast, "hower")){
					background.state = "rainyDay"
				}else if(Utilities.substr(wordedForecast, "loud")){
					background.state = "cloudyDay"
				}else if(Utilities.substr(wordedForecast, "unn")){
						background.state = "sunnyDay"
					}

			}
			onWordedForecastChanged:  {
				if(days.currentIndex == index)
					setBackground()
			}

			onClicked:{
				days.currentIndex = index
				setBackground()
			}
		}
		highlight: Rectangle{color: "darkblue"; radius: 5; height: 80; y: days.currentItem.y+13}
		onCurrentIndexChanged: detailList.currentIndex = currentIndex


		highlightMoveDuration: 500
		Behavior on y {NumberAnimation {duration: 750}}
		Behavior on opacity {NumberAnimation {duration: 500}}
	}




	ListView {
		property int shownY: 20

		id: detailList
		y: 0
		z:50
		height: 320
		width: parent.width
		opacity: 0
		snapMode: ListView.SnapToItem
		anchors.right: parent.right
		anchors.rightMargin: 200
		anchors.left: parent.left
		anchors.leftMargin: 0
		orientation: ListView.Horizontal
		boundsBehavior: Flickable.StopAtBounds
		delegate: DetailDelegate{
			id: detailDelegate
			width: mainwindow.width
			height: mainwindow.height-days.height
		}


		highlightFollowsCurrentItem: true
		interactive: false
		highlightMoveDuration: 500
		Behavior on y{NumberAnimation {duration: 750}}
		Behavior on opacity{ NumberAnimation{duration: 500}}
	}

	ListView {
		id: cityView
		width: mainwindow.width
		height: 48
		opacity: 0
		anchors.left: parent.left
		anchors.leftMargin: 0
		anchors.top: parent.top
		interactive: false
		anchors.topMargin: 0
		delegate: CityDelegate{}
		Behavior on opacity{ NumberAnimation {duration: 500}}
		states: [
			State {
				name: "portrait"
				when: mainwindow.width < mainwindow.height
				PropertyChanges {target: cityView; anchors.topMargin: 45; anchors.leftMargin: -75}
				PropertyChanges {target: zipField; state: "portrait"}
				PropertyChanges {target: days; downValue: 800; upValue: 705}
				PropertyChanges {target: detailList; shownY: 40}
				PropertyChanges {target: settings; state: "portrait"}
			}
		]
	}




 states: [
	 State {
		 name: "Landscape"
		 PropertyChanges {target: days; y: upValue; focus: true; opacity: 1; model: model}
		 PropertyChanges {target: detailList; y: shownY ;opacity: 1; model: model}
		 PropertyChanges {target: cityView;opacity: 1;  model: model}
	 },
	 State {
		 name: "home1"
		 PropertyChanges {target: days; y: upValue; opacity: 1; focus: true; model: home1Model}
		 PropertyChanges {target: detailList; y: shownY ;opacity: 1; model: home1Model}
		 PropertyChanges {target: cityView; opacity: 1; model: home1Model}
	 },
	 State {
		 name: "home2"
		 PropertyChanges {target: days; y: upValue; opacity: 1; focus: true; model: home2Model}
		 PropertyChanges {target: detailList; y: shownY ;opacity: 1; model: home2Model}
		 PropertyChanges {target: cityView; opacity: 1; model: home2Model}
	 },
	 State {
		name: "getZip"
		PropertyChanges {target: zipField; opacity: 1; focusEntry: true}
		PropertyChanges {target: days; y: 480; focus: true; opacity: 0}
		PropertyChanges {target: detailList; y: 0;opacity: 0}
		PropertyChanges {target: background; state: ""}

	 },
	State {
		name: "loading"
		PropertyChanges {target: loadScreen; paused: false;opacity: 1}
		PropertyChanges {target: days; y: 480; focus: true; opacity: 0}
		PropertyChanges {target: detailList; y: 0}
  },
	 State {
		name: "settings"
		PropertyChanges {target: settings; opacity: 1}
		PropertyChanges {target: days; y: 480; focus: true; opacity: 0}
		PropertyChanges {target: cityView; opacity: 0}
		PropertyChanges {target: detailList; y: 0}
	 }

 ]


 EntryField {
	Behavior on opacity{NumberAnimation { duration: 500 }}
	id: zipField
	text: "Enter a Zipcode"
	anchors.centerIn: parent
	opacity: 0
	onAccepted: {
		model.source = "http://umcs.maine.edu/~naddeoa/?zipcode=" + entryPlaceholder
		mainwindow.state = "loading"
	 }

 }


 MouseArea {
	id: exitArea
	x: 728
	width: 48
	height: 48
	z: 2
	anchors.right: parent.right
	anchors.rightMargin: 10
	anchors.top: parent.top
	anchors.topMargin: 0
	onClicked: Qt.quit()

	Image {
		id: image1
		z: 24
		anchors.fill: parent
		source: "qrc:///images/qml/qtweather-qml/images/x.png"
	 }
 }

 MouseArea {
	id: home1Area
	x: 548
	width: 48
	height: 48
	z: 2
	anchors.right: parent.right
	anchors.rightMargin: 146
	anchors.top: parent.top
	anchors.topMargin: 0
	Timer {id: home1Timer; onTriggered: mainwindow.state = "home1"}
	onClicked: {
		if(home1Model.source != "http://umcs.maine.edu/~naddeoa/?zipcode=" + Utilities.home1()){
			mainwindow.state = "loading"
			home1Model.source = "http://umcs.maine.edu/~naddeoa/?zipcode=" + Utilities.home1()
		}
		else if(mainwindow.state != "home1"){
			mainwindow.state = "loading"
			home1Timer.start()
		}

	}

	Image {
		id: home1icon
		z: 26
		anchors.fill: parent
		source: "qrc:///images/qml/qtweather-qml/images/home1.png"
	}
 }

 MouseArea {
	id: home2Area
	x: 641
	width: 48
	height: 48
	z: 2
	anchors.right: parent.right
	anchors.rightMargin: 78
	anchors.top: parent.top
	anchors.topMargin: 0
	Timer {id: home2Timer; onTriggered: mainwindow.state = "home2"}
	onClicked: {
	  if(home2Model.source != "http://umcs.maine.edu/~naddeoa/?zipcode=" + Utilities.home2()){
		  mainwindow.state = "loading"
		  home2Model.source = "http://umcs.maine.edu/~naddeoa/?zipcode=" + Utilities.home2()
	  }
	  else if(mainwindow.state != "home2"){
		  mainwindow.state = "loading"
		  home2Timer.start()
	  }

  }

	 Image {
		id: home2icon
		z: 16
		anchors.fill: parent
		source: "qrc:///images/qml/qtweather-qml/images/home2.png"
	 }
 }

 MouseArea {
	id: webArea
	x: 461
	width: 48
	height: 48
	z: 2
	anchors.right: parent.right
	anchors.rightMargin: 214
	anchors.top: parent.top
	anchors.topMargin: 0
	onClicked:{
		Qt.openUrlExternally("http://forecast.weather.gov/zipcity.php?inputstring=" + entry.text)
	}

	 Image {
		id: webIcon
		z: 42
		anchors.fill: parent
		source: "qrc:///images/qml/qtweather-qml/images/web.png"

	 }

 }

 MouseArea {
	id: settingsArea
	x: 364
	width: 48
	height: 48
	z: 2
	anchors.right: parent.right
	anchors.rightMargin: 282
	anchors.top: parent.top
	anchors.topMargin: 0
	onClicked: mainwindow.state = "settings"

	Image {
		id: settingsIcon
		z: 21
		anchors.fill: parent
		source: "qrc:///images/qml/qtweather-qml/images/settings.png"
	 }
 }

 MouseArea {
	id: minArea
	y: -1
	width: 60
	height: 48
	z: 2
	anchors.left: parent.left
	anchors.leftMargin: 10
	onClicked: {
		Utilities.minimize()
	}

	Image {
		id: minIcon
		anchors.fill: parent
		source: "qrc:///images/qml/qtweather-qml/images/minimize.png"
	 }
 }



 Loading {
	id: loadScreen
	x: 25
	y: 26
	opacity: 0
	anchors.fill: parent
	paused: true
	Behavior on opacity{
		 NumberAnimation{duration: 500}
	 }
 }

 MouseArea {
	id: searchArea
	x: 397
	y: 0
	width: 48
	height: 48
	z: 2
	anchors.top: parent.top
	anchors.topMargin: 0
	Image {
		id: searchIcon
		smooth: true
		anchors.fill: parent
		source: "qrc:///images/qml/qtweather-qml/images/search.png"
		z: 26
	 }
	anchors.rightMargin: 350
	anchors.right: parent.right
	onClicked:{
		 if(mainwindow.state == "getZip")
			mainwindow.state = "Landscape"
		 else
			 mainwindow.state = "getZip"
	 }
 }

 Settings {
	 selected: Utilities.defaultHome()
	 zip1: Utilities.home1()
	 zip2: Utilities.home2()
	 id: settings
	 x: 0
	 y: 0
	 opacity: 0
	 Behavior on opacity {NumberAnimation{duration:500}}
 }

 Rectangle {
	 id: rectangle1
	 x: 10
	 y: 320
	 width: 60
	 height: 52
	 visible: false
	 color: "#ffffff"

	 MouseArea {
		 id: mouse_area1
		 anchors.fill: parent
		 drag.minimumY: -1000
		 drag.minimumX: -1000
		 drag.maximumY: 1000
		 drag.maximumX: 1000
		 onClicked: {
			 if(mainwindow.width == 480){
				 mainwindow.width = 800
				 mainwindow.height = 480
			 }else{
				 mainwindow.width = 480
				 mainwindow.height = 800
			 }


		 }
	 }
 }

 Background {
	 id: background
	 z: -1
	 anchors.fill: parent
 }











}
