import QtQuick 1.0

Item{
	signal clicked()

	id: delegateItem
	width: delegateRow.width+40; height: delegateRow.height + 40


	Rectangle{
		id: delegateRect
		width: parent.width; height: parent.height
		anchors.verticalCenter: parent.verticalCenter
		anchors.horizontalCenter: parent.horizontalCenter
		color: "transparent"


		MouseArea{
			id: area
			width: delegateRow.width+40; height: delegateRow.height + 40
			Connections{
				onClicked: clicked()
			}
		}

		Row{
			id: delegateRow
			anchors.verticalCenter: delegateRect.verticalCenter
			anchors.horizontalCenter: delegateRect.horizontalCenter
			spacing: 10


			Column{
				Rectangle{
					width: 64
					height: 64
					color: "transparent"
					Image {id: forecastIcon;width: 64; height: 64;source: iconurl; z:1}
					Image {id: loadingIcon;width: 64; height: 64;source: "qrc:///images/qml/qtweather-qml/images/loading.png"; x: forecastIcon.x; y: forecastIcon.y}
				}


			}
			Column{
				Text{text: day; font.bold: true; font.pixelSize: 18; color: "white"; font.family: "URW Gothic L"}
				Text{text: condition; font.bold: true; font.pixelSize: 14; color: "white"; font.family: "URW Gothic L"}
				Text{text: temp; font.bold: true; font.pixelSize: 14; color: "white"; font.family: "URW Gothic L"}
			}
		}
	}
}

