/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
 *
 */

//#include <stdlib.h>

#include "utils.h"

#include <Qt>
#include "eWallet.h"
#include "Constants.h"
#include "DetailedWindow.h"
#include "QLabelW.h"

#ifdef Q_WS_MAEMO_5
#include <QDBusInterface>
#include <QDBusConnection>
#endif
#include <QDesktopServices>


QLabelW::QLabelW(const QString &text, bool isLabel, bool isImage, bool isEdit, QWidget *parent, Qt::WindowFlags f) : QLabel (text, parent, f) {
	this->isLabel = isLabel;
	this->isImage = isImage;
	this->isEdit = isEdit;
	this->modified = false;
	this->image = NULL;

	if ((!isLabel) || isImage) {
		setContextMenuPolicy(Qt::CustomContextMenu);
		QObject::connect(this, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(labelMenu(const QPoint&)));

		if (isImage) {
			this->setBackgroundRole(QPalette::NoRole);
			//this->setContentsMargins(5, 2, 0, 2);
			this->setMaximumSize(OTHER_WIDTH, OTHER_HEIGH);
			//this->setMinimumSize(BIG_WIDTH, BIG_HEIGH);
			this->setScaledContents(true);
//			}
//			else {
//				imageLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
//				imageLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
//				imageLabel->setScaledContents(true);
//			}
		}
	}
}

QLabelW::QLabelW(QWidget *parent, Qt::WindowFlags f): QLabel (parent, f) {
}

QLabelW::~QLabelW() {
	if (image != NULL) {
		qDebug () << "destroy image " << image;
		delete image; // TODO sure??
		image = NULL;
	}
}

QImage * QLabelW::getPicture () {
	return image;
}

void QLabelW::readImage (TargetField * field) {
	if (image == NULL)
		field->value = "";
	else {
		eWallet::preProcessImage (image);

		QByteArray im2;
		QBuffer buffer2(&im2);

		buffer2.open(QIODevice::WriteOnly);
		image->save(&buffer2, "PNG"); // writes image into ba in PNG format

		field->value = QString (im2.toBase64());
	}
	qDebug () << "getting IMAGE field " << image << " " << field->value.length() << " bytes";
}

void QLabelW::setPicture (TargetField * field) {
	//TargetField * f = ((ButtonInfo *)this->userData(0))->field;

	image = NULL;
	if (field->value.length() > 0) {
		image = new QImage ();

		qDebug () << "exist image " << field->value.length() << " bytes";
		//QByteArray im_s;
		//decrypt(query.value(0).toByteArray(), im_s);
		if (!image->loadFromData (QByteArray::fromBase64(field->value.toAscii()))) {

		}
	}

	if (image == NULL) {
		QPixmap available(":/resources/empty_card.png");
		this->setPixmap(available);
	}
	else {
		this->setPixmap(QPixmap::fromImage (*image));
	}
}


void QLabelW::labelMenu(const QPoint & _p) {
   	TargetField * f = ((ButtonInfo *)this->userData(0))->field;

	if ((f->value != NULL && f->value.length() > 0) || f->type == TYPE_IMAGE) {
		QMenu menu(this);
		if (f->type == TYPE_URL) {
			menu.addAction(tr("Go to"), this, SLOT(m_goto()));
			menu.addAction(tr("Copy"), this, SLOT(m_copy()));
			//QDesktopServices::openUrl(QUrl::fromUserInput(f->value));
		}
		else {
			if (f->type == TYPE_PHONE_NUMBER) {
				QString telf = f->value;
				telf = telf.simplified();
				telf = telf.replace(" ", "");

				if (telf.length() > 0) {
					menu.addAction(tr("Call to").arg(telf), this, SLOT(m_call()));
				}
				//menu.addAction(tr("SMS to"), tmp, SLOT(m_sms()));
				menu.addAction(tr("Copy"), this, SLOT(m_copy()));
			}
			else {
				if (f->type == TYPE_IMAGE) {
					if (isEdit) {
						menu.addAction(tr("Edit"), this, SLOT(m_editImage()));
						//menu.addAction(tr("Mirror"), this, SLOT(mirrorFace()));
						menu.addAction(tr("Rotate"), this, SLOT(m_rotateImage()));
						menu.addAction(tr("Delete"), this, SLOT(m_deleteImage()));
					}
					else {
						menu.addAction(tr("Export"), this, SLOT(m_exportImage()));
					}
				}
				else
					menu.addAction(tr("Copy"), this, SLOT(m_copy()));
			}
		}
		menu.exec(_p);
	}
}
void QLabelW::m_editImage () {
   	TargetField * f = ((ButtonInfo *)this->userData(0))->field;

	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                tr("Choose image"),
	                path,
	                tr("Images (*.png *.jpg *.gif *.jpeg);;"));

	if (!s.isNull () && !s.isEmpty ()) {
		////qDebug () << "loading " << s;
		if (image) delete image;

		image = new QImage ();
		DetailWindow::loadImage(settings, s, *image); //;
		////qDebug () << "loaded " << s;
		this->setPixmap(QPixmap::fromImage (*image));
		////qDebug () << "asigned " << s;
		//update();
		//deleteFace = false;
		modified = true;
	}
}
void QLabelW::m_rotateImage () {
   	TargetField * f = ((ButtonInfo *)this->userData(0))->field;

   	if (image != NULL) {
		QImage * tmp = image;

		QMatrix m;
		m.rotate(90);
		image = new QImage (tmp->transformed(m));

		this->setPixmap(QPixmap::fromImage (*image));
		delete tmp;
		modified = true;
   	}
}
void QLabelW::m_deleteImage () {
   	TargetField * f = ((ButtonInfo *)this->userData(0))->field;

   	if (image != NULL) {
		modified = true;
		delete image;
		image = NULL;
		QPixmap available(":/resources/empty_card.png");
		this->setPixmap(available);
   	}
}
void QLabelW::m_exportImage () {
   	TargetField * f = ((ButtonInfo *)this->userData(0))->field;

	DetailWindow::exportImage(this, image, f->name, tr("Choose image file"));
}

void QLabelW::m_copy () {
   	TargetField * f = ((ButtonInfo *)this->userData(0))->field;

	if (f->type != TYPE_IMAGE) {
#ifdef Q_WS_MAEMO_5
		show_banner(this, tr("%1 has been saved to clipboard").arg(f->name));
#endif
		QClipboard *cb = QApplication::clipboard();
		cb->setText(f->value);
	}
}

void QLabelW::m_goto () {
	TargetField * f = ((ButtonInfo *)this->userData(0))->field;
	if (f->type == TYPE_URL && !isLabel) {
		QDesktopServices::openUrl(QUrl::fromUserInput(f->value));
	}
}

void QLabelW::m_sms () {

}

void QLabelW::m_call () {
#ifdef Q_WS_MAEMO_5
    TargetField * f = ((ButtonInfo *)this->userData(0))->field;
	if (!isLabel) {
		if (f->type == TYPE_PHONE_NUMBER) {
//    				QSettings settings;


//			XQTelephony *telephony = new XQTelephony(this);
//			telephony->call("+919464763259");//caller number

			QString telf = f->value;
			telf = telf.simplified();
			telf = telf.replace(" ", "");

			if (telf.length() > 0) {
				qDebug () << "calling to " << telf;
				QDBusConnection conn = QDBusConnection::systemBus(); //QString(MCE_SERVICE), QString(MCE_SIGNAL_PATH)
				QDBusInterface dbusPhone( QString ("com.nokia.csd.Call"), QString ("/com/nokia/csd/call"), QString ("com.nokia.csd.Call"), conn );
				QDBusMessage msg = dbusPhone.call( QString ("CreateWith"), telf, (uint)0 );
				qDebug() << msg;
			}
		}
	}
#endif
}

void QLabelW::mousePressEvent(QMouseEvent *) {
	TargetField * f = ((ButtonInfo *)this->userData(0))->field;

	if (isLabel) {
		m_copy ();
	}
 }

