/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
 */

#include "Constants.h"
#include "ImageViewer.h"
#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>


ImageViewer::ImageViewer(QImage * image, QWidget *parent) : QMainWindow(parent)
{
	setWindowTitle("Wallet");

	//this->setAttribute(Qt::WindowFlags, Qt::FramelessWindowHint);

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
	//connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));
	this->setAttribute(Qt::WA_Maemo5StackedWindow);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	centralWidget = new QLabel(this);

	centralWidget->setBackgroundRole(QPalette::Base);
	//centralWidget->setSizePolicy(QSizePolicy::Ignored, QSizePolicy::Ignored);
	centralWidget->setScaledContents(true);

	entryScrollArea = new QScrollArea;
	//entryScrollArea->setWidgetResizable(true);
	entryScrollArea->setWidget(centralWidget);
	entryScrollArea->setProperty("FingerScrollable", true);
	setCentralWidget(entryScrollArea);

	centralWidget->setPixmap(QPixmap::fromImage (*image));

	currentImage = image;

	recalculate ();

	centralWidget->resize(currentImage->size() * factor);
	tickTimer = 0;

//	defaultMargins = entryScrollArea->contentsMargins();
//	new FullScreenExitButton(this);
//	QWidget::showFullScreen();
}

ImageViewer::~ImageViewer() {
	if (tickTimer != 0) {
		this->killTimer(tickTimer);
		tickTimer = 0;
	}

}

void ImageViewer::orientationChanged(int o) {

}

void ImageViewer::mousePressEvent(QMouseEvent * mouseEvent) {
	//qDebug () << "mousePressEvent";
	if (tickTimer == 0) {
		tick = 0;
		tickTimer = this->startTimer(100);

		position = mouseEvent->pos();

		//qDebug () << "fixed position " << position << " " << entryScrollArea->horizontalScrollBar()->value () << " " << entryScrollArea->verticalScrollBar()->value ();
	}
}

void ImageViewer::mouseReleaseEvent(QMouseEvent * mouseEvent) {
	//qDebug () << "mouseReleaseEvent";
	if (tickTimer != 0) {
		this->killTimer(tickTimer);
		tickTimer = 0;
	}
//	if (tick <= 10) {
//	}
}

void ImageViewer::timerEvent(QTimerEvent *event) {
	if (tickTimer == event->timerId()) {
		tick++;
		if (tick > 5) {
//			if (factor < 5.0) {
				factor *= 1.03;

				QSize oldSize = centralWidget->size();
				QSize newSize = currentImage->size() * factor; // centralWidget->size() * 1.03; //

				if (newSize.width() > 2400 || newSize.height() > 2400) {

				}
				else {
					centralWidget->resize(newSize);

					//position += QPoint (newSize.width() - oldSize.width(), newSize.height() - oldSize.height());
					//QPoint u = position * factor;

					//qDebug () << "new position " << position;

					//entryScrollArea->ensureVisible(position.rx(), position.ry());

					QRect screenGeometry = QApplication::desktop()->screenGeometry();
					int wi = entryScrollArea->width(); //screenGeometry.width();
					int he = entryScrollArea->height(); //screenGeometry.height();

					entryScrollArea->horizontalScrollBar()->setValue(entryScrollArea->horizontalScrollBar()->value() + ((newSize.width() - oldSize.width()) * position.rx()) / wi);
					entryScrollArea->verticalScrollBar()->setValue(entryScrollArea->verticalScrollBar()->value() + ((newSize.height() - oldSize.height()) * position.ry()) / he);
					//entryScrollArea->verticalScrollBar()->setValue(0);
					//qDebug () << "NEW position f=" << factor << " " << wi << "-" << he << " " << newSize << " " << entryScrollArea->horizontalScrollBar()->value () << " " << entryScrollArea->verticalScrollBar()->value ();
				}
			}
//		}
	}

}

void ImageViewer::mouseDoubleClickEvent ( QMouseEvent * event ) {
	recalculate ();
	centralWidget->resize(currentImage->size() * factor);
}

//bool ImageViewer::event(QEvent *event)
//{
////	qDebug () << "event " << event;
//
//	//if (event->type() == Qt::E)
//
////    if (event->type() == QEvent::Gesture)
////        return gestureEvent(static_cast<QGestureEvent*>(event));
//    return QWidget::event(event);
//}


void ImageViewer::recalculate () {
	if (currentImage->width() <= 800 && currentImage->height() > 400)
		factor = 400 / currentImage->height();
	else
	if (currentImage->width() > 800 && currentImage->height() <= 400)
		factor = 800 / currentImage->width();
	else
	if (currentImage->width() < 800 && currentImage->height() < 400) {
		double x2 = factor = 800 / currentImage->width();
		double x1 = factor = 400 / currentImage->height();

		factor = x1 > x2 ? x1 : x2;
	}
	else
		factor = 1.0;
}

void ImageViewer::toggleFullScreen()
{
	bool isFullScreen = windowState() & Qt::WindowFullScreen;
	if (isFullScreen)
		showNormal();
	else
		showFullScreen();
}

void ImageViewer::changeEvent(QEvent *event)
{
	if (event->type() == QEvent::WindowStateChange) {

		// set the content margins to 0 in full screen mode,
		// so our fullScreenButton will be nicely visible
		const bool isFullScreen = windowState() & Qt::WindowFullScreen;
		if (isFullScreen)
			layout()->setContentsMargins(0, 0, 0, 0);
		else
			layout()->setContentsMargins(defaultMargins);
	}

	QWidget::changeEvent(event);
}
