/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
// TODO several files? or several wallets in database?
// TODO import picture from camera
// TODO modify picture (zoom, ...)
 * TODO after change type it is not refreshed on list
 * TODO implements copy of information field (and images?)
 * TODO check types on import
 * TODO sort after insert new card
 * TODO pc version?
 * TODO fix problems with key
 * TODO after import groups are not refresh
 * TODO get language from system not from regional settings
 * TODO export to xml
 * TODO import from xml
 * TODO avoid close application when changing password
 * TODO move fields value into a big field
 * TODO what happens with small pictures
  */

#include "utils.h"
#include <QDBusInterface>
#include <QDBusConnection>

#include "eWallet.h"
#include "Constants.h"
#include "DatabaseManager.h"
#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>



//#include <gtkmm.h>
//#include <hildonmm.h>
//#include <gtk.h>//hildon-notify/hildon/hildon-notification.h>

//#ifdef Q_WS_MAEMO_5
//#include <mce/mode-names.h>
//#include <mce/dbus-names.h>
//#endif

DatabaseManager * dbManager;

RenameGroupDialog::RenameGroupDialog(QWidget *paTarget) : QDialog(paTarget)
{
	setWindowTitle("Wallet");

	setContextMenuPolicy(Qt::NoContextMenu);
	QHBoxLayout * layout = new QHBoxLayout(this);

	layout->setMargin(0);
	layout->setSpacing(0);

	layout->setSpacing(10);
	layout->setMargin(10);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	QPushButton * closeButton = new QPushButton(tr("Save && Close"), this);
	//closeButton->setFixedHeight(70);
	closeButton->setContextMenuPolicy(Qt::NoContextMenu);
	closeButton->setFocusPolicy(Qt::NoFocus);
	closeButton->setIconSize(QSize(48, 48));
	QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(save()));
	dlgBtnBox->addButton(closeButton, QDialogButtonBox::ActionRole);

	QGridLayout * componentLayout = new QGridLayout ();
	componentLayout->setContentsMargins(15, 0, 15, 0);
	componentLayout->setSpacing(5);

	// Name label
	QLabel * nameLabel = new QLabel(tr("Name"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(nameLabel, 1, 1, 1, 2);

// Name line edit
	nameLineEdit = new QLineEdit(this);
	nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLineEdit->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);
	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);
}

void RenameGroupDialog::setName (const QString & name) {
	nameLineEdit->setText (name);
}

QString RenameGroupDialog::getName () {
	return nameLineEdit->text();
}

void RenameGroupDialog::save () {
	//update ();
	close();
}
RenameGroupDialog::~RenameGroupDialog() {

}


eWallet::eWallet(QString * group, eWallet * _parent, QWidget *parent) : QMainWindow(parent)
{
	setWindowTitle("Wallet");

	isFirst = false;
	types = _parent->types;
	fieldsByType = _parent->fieldsByType;

	centralWidget = NULL;
	currentGroup = group;

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
	//connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));

	this->setAttribute(Qt::WA_Maemo5StackedWindow);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	ascSort = true;
	currentFilter = "";

	isShowGroups = 2;

	showList (true);
	showTargets(true, currentGroup);
}

eWallet::eWallet(QWidget *parent) : QMainWindow(parent)
{
    QCoreApplication::setOrganizationName("nowheremanmail");
    QCoreApplication::setOrganizationDomain("gmail.com");
    QCoreApplication::setApplicationName("qtWallet");

    setWindowTitle("Wallet");

	isFirst = true;
	currentGroup = NULL;
	centralWidget = NULL;
	isShowGroups = 0;

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
	connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));

	this->setAttribute(Qt::WA_Maemo5StackedWindow);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	ascSort = true;
	currentFilter = "";

	loadTypesAndFields ();

	::dbManager = new DatabaseManager(this);

	askPassword ();

#ifdef Q_WS_MAEMO_5
	QDBusConnection conn = QDBusConnection::systemBus(); //QString(MCE_SERVICE), QString(MCE_SIGNAL_PATH)
	bool success = conn.connect("","", QString("com.nokia.mce.signal"/*MCE_SIGNAL_IF*/), QString("display_status_ind"/*MCE_DISPLAY_SIG*/) , this, SLOT(listenInactivity(QString)));
	//bool success = conn.connect("","", QString(MCE_SIGNAL_IF), QString(MCE_DISPLAY_SIG) , this, SLOT(listenInactivity(QString)));
#endif
}


void eWallet::orientationChanged(int o) {
	if (isAskPassword) {
		loginDialogDlg->orientationChanged (o);
	}
}

void eWallet::showList (bool interactive) {
	//qDebug () << "going to showList";

	isAskPassword = false;
	isChangingPassword = false;

	setProperty("FingerScrollable", false);
	centralWidget = new QWidget(this);
	//centralWidget->grabGesture(Qt::SwipeGesture);

//		grabGesture(Qt::PanGesture);
//		grabGesture(Qt::PinchGesture);
//	    grabGesture(Qt::SwipeGesture);


	//backButton = new QPushButton("<< Back", this);

	if (interactive) {
		setContextMenuPolicy(Qt::DefaultContextMenu);
	}
	else {
		setContextMenuPolicy(Qt::NoContextMenu);
	}
//	centralWidget->setContextMenuPolicy(Qt::DefaultContextMenu);

	vboxlayout = new QVBoxLayout;
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);
	// Custom list box
	//vboxlayout->addWidget(backButton);

	fnListWidget = new QListWidget(this);
	fnListWidget->setSortingEnabled(false);
	fnListWidget->setFocusPolicy(Qt::NoFocus);
	vboxlayout->addWidget(fnListWidget);

	//fnListWidget->grabGesture(Qt::SwipeGesture);

	if (interactive) {
		QObject::connect(fnListWidget, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(selectItem(QListWidgetItem *)));
		QObject::connect(fnListWidget, SIGNAL(itemDoubleClicked(QListWidgetItem *)), this, SLOT(selectDItem(QListWidgetItem *)));

		inputWidget = new QHBoxLayout;
		inputWidget->setContentsMargins(2, 2, 2, 0);
		vboxlayout->addLayout(inputWidget);

		cancelSearch = new QPushButton(QIcon(":/resources/icon_clear.png"), "", this);
		searchField = new QLineEdit ();
		hideSearch = new QPushButton(QIcon(":/resources/icon_hide.png"), "", this);

		inputWidget->addWidget(cancelSearch);
		searchField->setText(currentFilter);
		searchField->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		inputWidget->addWidget(searchField);
		inputWidget->addWidget(hideSearch);

		//QObject::connect(backButton, SIGNAL(clicked()), this, SLOT(_clickBack()));
		//backButton->hide ();

		QObject::connect(cancelSearch, SIGNAL(clicked()), this, SLOT(_cancelSearch()));
		QObject::connect(hideSearch, SIGNAL(clicked()), this, SLOT(_hideSearch()));
		QObject::connect(searchField, SIGNAL(textChanged(const QString &)), this, SLOT(textChanged(const QString &)));
	}
	else {
		searchField = NULL;
		cancelSearch = NULL;
		hideSearch = NULL;
	}

	centralWidget->setLayout(vboxlayout);

	if (interactive) {
		createMenu ();
	}

	////qDebug () << "setCentralWidget(centralWidget);";
	setCentralWidget(centralWidget);

	////qDebug () << "setFocus()";
	centralWidget->setFocus ();
	//fnListWidget->setFocus ();

	if (interactive) {
		if (currentFilter.length () > 0) {
			cancelSearch->show ();
			searchField->show ();
			//setFocus ();
			//focusNextChild();
			searchField->setFocus();
			hideSearch->show ();
		}
		else {
			cancelSearch->hide ();
			searchField->hide ();
			hideSearch->hide ();
		}
	}
}

void eWallet::_clickBack () {
	isShowGroups = (isShowGroups) % 2 + 1;
	_cancelSearch ();
	showInfo(true);
}
void eWallet::changeMode () {
	isShowGroups = (isShowGroups) % 2 + 1;
	_cancelSearch ();
	showInfo(true);
}

////void eWallet::swipeTriggered(QSwipeGesture *gesture) {
////	if (gesture->state() == Qt::GestureFinished) {
////		if (gesture->horizontalDirection() == QSwipeGesture::Left
////			|| gesture->verticalDirection() == QSwipeGesture::Up)
////			isShowGroups = (isShowGroups + 1) % 2 + 1;
////		else
////			isShowGroups = (isShowGroups + 1) % 2 + 1;
////		showInfo(false);
////	}
////}
//
//bool eWallet::gestureEvent(QGestureEvent *event) {
//    if (QGesture *swipe = event->gesture(Qt::SwipeGesture))
//    	changeMode();
//
////        swipeTriggered(static_cast<QSwipeGesture *>(swipe));
////    else if (QGesture *pan = event->gesture(Qt::PanGesture))
////        panTriggered(static_cast<QPanGesture *>(pan));
////    if (QGesture *pinch = event->gesture(Qt::PinchGesture))
////        pinchTriggered(static_cast<QPinchGesture *>(pinch));
//    return true;
//}
//
//
//bool eWallet::event(QEvent *event)
//{
////	//qDebug () << "EVENT " << event->type();
//    if (event->type() == QEvent::Gesture) {
//    	//qDebug () << "GESTURE";
//
//    	if (!isAskPassword) {
//    		return gestureEvent(static_cast<QGestureEvent*>(event));
//    	}
//    }
//    return QWidget::event(event);
//}

void eWallet::selectItem(QListWidgetItem * item) {
#ifndef Q_WS_MAEMO_5
	if (!(extraWindow.isNull() && detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!extraWindow.isNull()) extraWindow->raise();
		else
		if (!detailWindow.isNull()) detailWindow->raise();
		else
		if (!detailWindowEdit.isNull()) detailWindowEdit->raise();
		return ;
	}
#endif
	if (isShowGroups == 1) {
		if (fnListWidget->currentItem() != item) {
			fnListWidget->setCurrentItem(item);
		}

		QString *_target;

		if (fnListWidget->currentRow() > 0) {
			_target = new QString (grouplist.at(fnListWidget->currentRow() - 1));
		}
		else
			_target = NULL;

		if (extraWindow.isNull()) {
			extraWindow = new eWallet(_target, this, this);
			extraWindow->setAttribute(Qt::WA_DeleteOnClose);
	        connect(extraWindow, SIGNAL(destroyed(QObject*)),
	                this, SLOT(windowDestroyedExtra(QObject*)));
	        extraWindow->show();
		}
		//showTargets(reset, target);
	}
	else {
		if (fnListWidget->currentItem() != item) {
			fnListWidget->setCurrentItem(item);
		}
		Target * target = list.at(fnListWidget->currentRow());
		viewTarget(target);
	}
}

void eWallet::selectDItem(QListWidgetItem * item) {
		selectItem(item);
}

void eWallet::listenInactivity(QString s) {
	////qDebug () << "HELLO " << s;
	if (s == QString("off") && ::dbManager->isReady ()) {
		::dbManager->lock ();

		// TODO sure????
		fnListWidget->clear();
		list.clear ();
		grouplist.clear ();

		if (!detailWindow.isNull()) {
			detailWindow->close();
			delete detailWindow;
			detailWindow = 0;
	    }

	    if (!detailWindowEdit.isNull()) {
			detailWindowEdit->forceclose();
			delete detailWindowEdit;
			detailWindowEdit = 0;
	    }

	    if (!extraWindow.isNull()) {
	    	extraWindow->close();
			delete extraWindow;
			extraWindow = 0;
	    }

	}
	else {
		if (s == QString("on") && !::dbManager->isReady ()) {
			askPassword ();
		}
	}
}

void eWallet::textChanged (const QString & text) {
	currentFilter = text;
	filterBy (text);
}

void eWallet::filterBy (const QString & s) {
	if (isShowGroups == 1) {
		bool isIncluded = false;

		isIncluded = tr("<All>").contains(s, Qt::CaseInsensitive);
		if (s.length() == 0) {
			fnListWidget->item(0)->setHidden(false);
		}
		else {
			if (isIncluded) {
				fnListWidget->item(0)->setHidden(false);
			}
			else {
				fnListWidget->item(0)->setHidden(true);
			}
		}

		for (int i = 0; i < grouplist.size (); i++) {
			if (i > 0 || (i == 0 && grouplist.at(0).length () > 0)) {
				QString target = grouplist.at(i);
				isIncluded = target.contains(s, Qt::CaseInsensitive);
			}
			else {
				isIncluded = tr("<No Group>").contains(s, Qt::CaseInsensitive);
			}
			//qDebug () << " GROUP 4 " << i;

			////qDebug () << "cc GROUP " << i;
			if (s.length() == 0) {
				fnListWidget->item(i+1)->setHidden(false);
			}
			else {
				if (isIncluded) {
					fnListWidget->item(i+1)->setHidden(false);
				}
				else {
					fnListWidget->item(i+1)->setHidden(true);
				}
			}
		}
	}
	else {
		for (int i = 0; i < list.size (); i++) {
			Target * target = list.at(i);

			if (s.length() == 0) {
				fnListWidget->item(i)->setHidden(false);
			}
			else {
				if (target->name.contains(s, Qt::CaseInsensitive)) {
					fnListWidget->item(i)->setHidden(false);
				}
				else {
					fnListWidget->item(i)->setHidden(true);
				}
			}
		}
	}
}

void eWallet::_cancelSearch () {
	currentFilter = "";
	searchField->setText("");
	searchField->hide();
	cancelSearch->hide();
	hideSearch->hide ();
}

void eWallet::_hideSearch () {
	searchField->hide();
	cancelSearch->hide();
	hideSearch->hide ();
}

void eWallet::lockWallet () {
	::dbManager->lock ();
	askPassword ();
}

void eWallet::deleteDB () {
	if (messageBox.isNull()) {
		messageBox = new QMessageBox(this);
		int b = messageBox->information(this, "Wallet", tr("Are you sure you want to remove all your data? You will lost all your data"), QMessageBox::Yes, QMessageBox::No);
		if (b == QMessageBox::Yes) {
			::dbManager->reset ();

			if (!loginDialogDlg.isNull()) {
				loginDialogDlg->resetF ();
			}
		}
	}
	delete messageBox;
	messageBox = 0;
}

bool eWallet::openDataBase (const QString & pas)
{
	bool res = ::dbManager->openDB(pas);

	if (!res) {
		if (++times > 3) {
			exit(3);
		}
		else {
			if (!::dbManager->isReady ()) {
#ifdef Q_WS_MAEMO_5
				show_banner (this, tr("Wrong password"));
#endif
#ifndef Q_WS_MAEMO_5
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet", tr("Wrong password"), QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;
#endif
			}
		}
	}
	else {
		if (isShowGroups == 0) {
			grouplist.clear ();
			grouplist = ::dbManager->getGroups ();

			if (grouplist.size() > 1) {
				isShowGroups = 1;
			}
			else
			if (grouplist.size() == 1) {
				if (grouplist.at(0).length() == 0) {
					isShowGroups = 2;
				}
				else {
					isShowGroups = 1;
				}
			}
			else {
				isShowGroups = 2;
			}
		}

		showList (true);
		showInfo (true);
	}
	return res;
}

eWallet::~eWallet ()
{
	if (currentGroup != NULL)
		delete currentGroup;
	//delete ::dbManager;
}



/*
 * TYPES
 * 	S -> String
 * 	T -> Text
 * 	D -> Date
 *  U -> URL
 *  P -> Password
 *  N -> Number
 *  H -> Phone number
 */
void eWallet::loadTypesAndFields () {
	  types = new QList<QString>;
	  fieldsByType = new QList<QList<TargetField>*>;

	  this->types->append(QString("Membership Info"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Organization"),TYPE_STRING, true, 2,"Organization"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Phone Number"),TYPE_PHONE_NUMBER, true, 3,"Phone Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Other Information"),TYPE_STRING, true, 4,"Other Information"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("User Name"),TYPE_STRING, true, 5,"User Name"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Password"),TYPE_PASSWORD, true, 6,"Password"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Organization club"),TYPE_STRING, true, 7,"Organization club"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("ID Number"),TYPE_INTEGER, true, 8,"ID Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("URL"),TYPE_URL, true, 9,"URL"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Notes"),TYPE_TEXT, true, 10,"Card Notes"));
	  this->types->append(QString("Password"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("System"),TYPE_STRING, true, 2,"System"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("User Name"),TYPE_STRING, true, 3,"User Name"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Password"),TYPE_PASSWORD, true, 4,"Password"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("URL"),TYPE_URL, true, 5,"URL"));
	  this->types->append(QString("Credit Card"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Credit Card Type"),TYPE_STRING, true, 2,"Credit Card Type"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Provider"),TYPE_STRING, true, 3,"Card Provider"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Number"),TYPE_INTEGER, true, 4,"Card Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Expiration Date"),TYPE_DATE, true, 5,"Expiration Date"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Name on Card"),TYPE_STRING, true, 6,"Name on Card"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Phone Number"),TYPE_PHONE_NUMBER, true, 7,"Phone Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("PIN"),TYPE_PASSWORD, true, 8,"PIN"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Start Date"),TYPE_DATE, true, 9,"Start Date"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Expiration Date"),TYPE_DATE, true, 10,"Expiration Date"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Detail"),TYPE_STRING, true, 11,"Detail"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("3-digit CVC#"),TYPE_STRING, true, 12,"3-digit CVC#"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Notes"),TYPE_TEXT, true, 13,"Card Notes"));
	  this->types->append(QString("Bank Account"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Bank Name"),TYPE_STRING, true, 2,"Bank Name"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Account Number"),TYPE_INTEGER, true, 3,"Account Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Telephone"),TYPE_PHONE_NUMBER, true, 4,"Telephone"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("PIN"),TYPE_PASSWORD, true, 5,"PIN"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("SWIFT Code"),TYPE_STRING, true, 6,"SWIFT Code"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Other Information"),TYPE_STRING, true, 7,"Other Information"));
	  this->types->append(QString("Health Numbers"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("ID Number"),TYPE_INTEGER, true, 2,"ID Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Password"),TYPE_PASSWORD, true, 3,"Password"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Title"),TYPE_STRING, true, 4,"Card Title"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Notes"),TYPE_TEXT, true, 5,"Card Notes"));
	  this->types->append(QString("Passport Info"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Passport No"),TYPE_STRING, true, 2,"Passport No"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Surname"),TYPE_STRING, true, 3,"Surname"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Given names"),TYPE_STRING, true, 4,"Given names"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Date of birth"),TYPE_DATE, true, 5,"Date of birth"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Date of issue"),TYPE_DATE, true, 6,"Date of issue"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Date of expiration"),TYPE_DATE, true, 7,"Date of expiration"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Authority"),TYPE_STRING, true, 8,"Authority"));
	  this->types->append(QString("Note Card"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Text"),TYPE_STRING, true, 2,"Text"));
	  this->types->append(QString("Car Info"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Model"),TYPE_STRING, true, 2,"Model"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Vehicle Number"),TYPE_INTEGER, true, 3,"Vehicle Number"));
	  this->types->append(QString("Cellular Phone"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Model"),TYPE_STRING, true, 2,"Model"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Brand"),TYPE_STRING, true, 3,"Brand"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("IMEI#"),TYPE_STRING, true, 4,"IMEI#"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Firmware code"),TYPE_STRING, true, 5,"Firmware code"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Purchased"),TYPE_DATE, true, 6,"Purchased"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Pin1"),TYPE_STRING, true, 7,"Pin1"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Pin2"),TYPE_STRING, true, 8,"Pin2"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Puk1"),TYPE_STRING, true, 9,"Puk1"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Puk2"),TYPE_STRING, true, 10,"Puk2"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Num SIM"),TYPE_STRING, true, 11,"Num SIM"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Password"),TYPE_PASSWORD, true, 12,"Password"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Phone Number"),TYPE_PHONE_NUMBER, true, 13,"Phone Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Manufacturer"),TYPE_STRING, true, 14,"Manufacturer"));
	  this->types->append(QString("Serial Number Software"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Product"),TYPE_STRING, true, 2,"Product"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Version"),TYPE_STRING, true, 3,"Version"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Serial #"),TYPE_STRING, true, 4,"Serial #"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("URL"),TYPE_URL, true, 5,"URL"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Company"),TYPE_STRING, true, 6,"Company"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Date bought"),TYPE_DATE, true, 7,"Date bought"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Username"),TYPE_STRING, true, 8,"Username"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Login"),TYPE_STRING, true, 9,"Login"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Authorization key"),TYPE_STRING, true, 10,"Authorization key"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Price paid"),TYPE_STRING, true, 11,"Price paid"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Support"),TYPE_STRING, true, 12,"Support"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Notes"),TYPE_TEXT, true, 13,"Notes"));
	  this->types->append(QString("Serial Number Hardware"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Product"),TYPE_STRING, true, 2,"Product"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Serial #"),TYPE_STRING, true, 3,"Serial #"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Model #"),TYPE_STRING, true, 4,"Model #"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Bought from"),TYPE_STRING, true, 5,"Bought from"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Price paid"),TYPE_STRING, true, 6,"Price paid"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Guarantee period"),TYPE_DATE, true, 7,"Guarantee period"));
	  this->types->append(QString("Web site"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("URL"),TYPE_URL, true, 2,"URL"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Login"),TYPE_STRING, true, 3,"Login"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Password"),TYPE_PASSWORD, true, 4,"Password"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("E mail used"),TYPE_STRING, true, 5,"E mail used"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Notes"),TYPE_TEXT, true, 6,"Notes"));
	  this->types->append(QString("ID Card"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("ID Number"),TYPE_INTEGER, true, 2,"ID Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Title"),TYPE_STRING, true, 3,"Card Title"));
	  this->types->append(QString("Social Security Number"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Social Security Number"),TYPE_INTEGER, true, 2,"Social Security Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Name"),TYPE_STRING, true, 3,"Name"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Password"),TYPE_PASSWORD, true, 4,"Password"));
	  this->types->append(QString("Email Account"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("User Name"),TYPE_STRING, true, 2,"User Name"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Password"),TYPE_PASSWORD, true, 3,"Password"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("System"),TYPE_STRING, true, 4,"System"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Notes"),TYPE_TEXT, true, 5,"Card Notes"));
	  this->types->append(QString("Driver's License"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Driver's License Number"),TYPE_INTEGER, true, 2,"Driver's License Number"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Date Issued"),TYPE_DATE, true, 3,"Date Issued"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Expiration Date"),TYPE_DATE, true, 4,"Expiration Date"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("URL"),TYPE_URL, true, 5,"URL"));
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Password"),TYPE_PASSWORD, true, 6,"Password"));
	  this->types->append(QString("Others"));
	  this->fieldsByType->append (new QList<TargetField>);
	  this->fieldsByType->at(this->types->length() - 1)->append(TargetField(tr("Card Notes"),TYPE_TEXT, true, 2,"Card Notes"));

//	  QFile file(":/resources/types.txt");
//	  QString line;
//
//	  if ( file.open(QIODevice::Text | QIODevice::ReadOnly) ) {
//	    // file opened successfully
//	    QTextStream t(&file);        // use a text stream
//	    // until end of file...
//	    int i = 0;
//	    while ( !t.atEnd() ) {
//	      // read and parse the command line
//	      QString line = t.readLine();         // line of text excluding '\n'
//	      // do something with the line
//
//	      if (line.length() > 0) {
//	    	  if ((i++) == 0) {
//	    		  int p = line.indexOf(';');
//	    		  if (p >= 0) {
//	    			  // TODO
//	    			  QChar imageType = line.at(p + 1);
//					  this->types->append(line.mid(0, p).trimmed());
//	    		  }
//	    		  else {
//					  this->types->append(line);
//	    		  }
//	    		  this->fieldsByType->append (new QList<TargetField>);
//				  ////qDebug () << " new type "<< line << " " << this->types.length();
//	    	  }
//	    	  else {
//	    		  int p = line.indexOf(';');
//	    		  if (p >= 0) {
//	    			  int type = TYPE_STRING;
//	    			  switch (line.at(p + 1).toAscii()) {
//						  case 'T':
//							  type = TYPE_TEXT;
//							  break;
//						  case 'D':
//							  type = TYPE_DATE;
//							  break;
//						  case 'U':
//							  type = TYPE_URL;
//							  break;
//						  case 'P':
//							  type = TYPE_PASSWORD;
//							  break;
//						  case 'N':
//							  type = TYPE_INTEGER;
//							  break;
//						  case 'H':
//							  type = TYPE_PHONE_NUMBER;
//							  break;
//						  case 'S':
//						  default:
//			    			  type = TYPE_STRING;
//						}
//	    			  this->fieldsByType->at(this->types->length() - 1)->append(TargetField (line.mid(0, p).trimmed(), type, true, i));
//	    		  }
//	    		  else {
//	    			  this->fieldsByType->at(this->types->length() - 1)->append(TargetField (line, TYPE_STRING, true, i));
//	    		  }
//				  ////qDebug () << " new field "<< line << " " << this->types.length();
//	    	  }
//	      }
//	      else {
//	    	  i = 0;
//	      }
//
//	    }
//
//	    // Close the file
//	    file.close();
//	  }
}

void eWallet::keyPressEvent(QKeyEvent* event) {
	//qDebug()<<"key pressed " << event->key();
	
	if (!isAskPassword && searchField != NULL) {
		if (searchField->isHidden()) {
//			if (event->key () == Qt::Key_Left || event->key () == Qt::Key_Right ) {
//				changeMode();
//				event->accept();
//			}
//			else {
				cancelSearch->show ();
				searchField->show ();
				hideSearch->show ();
				searchField->setFocus();

				QCoreApplication::sendEvent (searchField, event);
				event->accept();
//			}
		}
		else {
				QWidget::keyPressEvent(event);//event->accept();
		}
	}
	else {
		QWidget::keyPressEvent(event);//event->accept();
	}
	//timer->stop();
	//timer->start(5000);
}

bool sortTargetsASC (const Target * f, const Target * g) {
	return f->name.toLower() < g->name.toLower();
}
bool sortTargetsDES (const Target * f, const Target * g) {
	return f->name.toLower() > g->name.toLower();
}
bool sortStringASC (const QString f, const QString g) {
	return f.toLower() < g.toLower();
}
bool sortStringDES (const QString f, const QString g) {
	return f.toLower() > g.toLower();
}

QPixmap eWallet::getImage (Target * target) {
	QPixmap image;
	if (target->getPictureSmall() != NULL) {
		image = QPixmap::fromImage (*target->getPictureSmall());

		// at this moment we don't need anymore original images!
		target->freeResources();
	} else {
		QString tmp = ":/resources/empty_";
		tmp += target->type.simplified().replace(' ', '_');
		tmp += ".png";

		if (QResource (tmp).isValid()) {
			image = QPixmap (tmp);
		}
		else {
			image = QPixmap (":/resources/empty_Others.png");
		}
	}
	return image;
}

void eWallet::showGroups(bool reset)
{
	//qDebug () << "show Groups " << reset;

	int current = fnListWidget->currentRow();

	// Clean previous items from the layout
	fnListWidget->clear();

	if (reset) {
		grouplist.clear ();
		grouplist = ::dbManager->getGroups ();
	}

	if (ascSort)
		qSort (grouplist.begin(),grouplist.end(),sortStringASC);
	else
		qSort (grouplist.begin(),grouplist.end(),sortStringDES);

//	fnListWidget->setIconSize (QSize (SMALL_WIDTH, SMALL_HEIGH));
//	fnListWidget->setContentsMargins(10, 1, 0, 1);

	QListWidgetItem* listitem = new QListWidgetItem(tr("<All>"), fnListWidget);

	//listitem->set(target->getSummary());
	fnListWidget->addItem(listitem);

	for (int i = 0; i < grouplist.size (); i++) {
		QString target = grouplist.at(i);

		QListWidgetItem * listitem;
		if (target.length() == 0) {
			listitem = new QListWidgetItem(tr("<No Group>"), fnListWidget);
		}
		else {
			listitem = new QListWidgetItem(target, fnListWidget);
		}
		//listitem->set(target->getSummary());
		fnListWidget->addItem(listitem);
	}

	filterBy(currentFilter);

	if (current >= 0 && current <= grouplist.size ())
		fnListWidget->setCurrentRow(current);
	else
		fnListWidget->setCurrentRow(0);

	update();
}

void eWallet::showInfo(bool reset) {
	if (isShowGroups == 1) {
		//backButton->hide();
		showGroups(reset);
	}
	else {
		showTargets(reset, currentGroup);
	}
}

void eWallet::showTargets(bool reset, const QString * filter)
{
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	//qDebug () << "show Targets " << reset;

	int current = fnListWidget->currentRow();

//#ifdef Q_WS_MAEMO_5
//	show_banner (this, tr("Loading data, please wait"));
//#endif

    //QApplication::instance()->processEvents();

	// Clean previous items from the layout
	fnListWidget->clear();

	if (reset) {
		list.clear ();
		list = ::dbManager->getTargets (filter);
	}

	if (ascSort)
		qSort (list.begin(),list.end(),sortTargetsASC);
	else
		qSort (list.begin(),list.end(),sortTargetsDES);

	fnListWidget->setIconSize (QSize (SMALL_WIDTH, SMALL_HEIGH));
	//fnListWidget->setContentsMargins(10, 1, 0, 1);

	for (int i = 0; i < list.size (); i++) {
		Target * target = list.at(i);

		QListWidgetItem* listitem = new QListWidgetItem(getImage(target), target->getName (), fnListWidget);
		//listitem->set(target->getSummary());
		fnListWidget->addItem(listitem);
		
	}

	filterBy(currentFilter);

	if (current >= 0 && current <= list.size ())
		fnListWidget->setCurrentRow(current);
	else
		fnListWidget->setCurrentRow(0);

	update();

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::createMenu()
{
	//qDebug () << "create Menu " << isAskPassword;
#ifdef Q_WS_MAEMO_5
	menuBar()->clear();
	if (isAskPassword) {
		menuBar()->addAction(tr("About"), this, SLOT(about()));
		if (!isChangingPassword) {
			menuBar()->addAction(tr("Delete DB"), this, SLOT(deleteDB()));
		}
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
	}
	else {
		menuBar()->addAction(tr("New"), this, SLOT(newTarget()));
		if (isShowGroups == 2)
			menuBar()->addAction(tr("Edit"), this, SLOT(_editcTarget()));
		menuBar()->addAction(tr("Invert Sort"), this, SLOT(sort()));
		menuBar()->addAction(tr("Import"), this, SLOT(import()));
		menuBar()->addAction(tr("Export"), this, SLOT(exportData()));
		//menuBar()->addAction(tr("Change View"), this, SLOT(changeMode()));
		menuBar()->addAction(tr("Change Password"), this, SLOT(changePassword()));
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
	}
#else
	menuBar()->clear();
	if (isAskPassword) {
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
		menuBar()->addAction(tr("About"), this, SLOT(about()));
//		if (!isChangingPassword) {
//			menuBar()->addAction(tr("Delete DB"), this, SLOT(deleteDB()));
//		}
	}
	else {
		QMenu * m = menuBar()->addMenu(tr("Card"));
		m->addAction(tr("New"), this, SLOT(newTarget()));
		if (isShowGroups == 2)
			m->addAction(tr("Edit"), this, SLOT(_editcTarget()));
		m->addSeparator();
		m->addAction(tr("Invert Sort"), this, SLOT(sort()));
		m->addSeparator();
		m->addAction(tr("Change Password"), this, SLOT(changePassword()));
		m->addSeparator();
		m->addAction(tr("Import"), this, SLOT(import()));
		m->addAction(tr("Export"), this, SLOT(exportData()));
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
		menuBar()->addAction(tr("About"), this, SLOT(about()));
		//menuBar()->addAction(tr("Change View"), this, SLOT(changeMode()));
	}
#endif
}

void eWallet::sort()
{
	ascSort = !ascSort;
	showInfo(false);
}

bool eWallet::__insertTarget(Target* target)
{
	if (::dbManager->insertTarget(target)) {
		////qDebug () << "Adding new item";
		::dbManager->updateFields (target);
		
		target->freeFieldList();
		return true;
	}
	return false;
}

bool eWallet::_insertTarget(Target* target)
{
	if (__insertTarget(target)) {
		if (isShowGroups == 2) {
			list.append(target);

	//		if (ascSort)
	//			qSort (list.begin(),list.end(),sortTargetsASC);
	//		else
	//			qSort (list.begin(),list.end(),sortTargetsDES);

			QListWidgetItem* listitem = new QListWidgetItem(getImage(target), target->name, fnListWidget);

			int pos = list.indexOf(target);
			//qDebug () << "position of new " << pos << " OF " << list.size ();

			if (pos < list.size()) {
				////qDebug () << "insert position of new " << pos << " OF " << list.size ();
				fnListWidget->insertItem(pos, listitem);
			}
			else {
				////qDebug () << "append position of new " << pos << " OF " << list.size ();
				fnListWidget->addItem(listitem);
			}
			fnListWidget->setCurrentItem(listitem);
		}
		else {
			showGroups(true);
		}
		return true;
	}
	return false;
}
bool eWallet::_deleteTarget(Target* target)
{
	if (messageBox.isNull()) {
		messageBox = new QMessageBox(this);
		int b = messageBox->information(this, "Wallet", tr("Are you sure you want to remove it?"), QMessageBox::Yes, QMessageBox::No);
		if (b != QMessageBox::Yes) {
			delete messageBox;
			messageBox = 0;

			return false;
		}
	}
	delete messageBox;
	messageBox = 0;

	if (::dbManager->deleteTarget(target)) {
		if (isShowGroups == 2) {
			int i = list.indexOf(target);
			//qDebug () << "DELETE ON " << i;
			//qDebug () << "trying to remove " << i;
			list.removeAt(i);

			//qDebug () << "trying to takeItem " << i;
			fnListWidget->takeItem(i); //oveItem (row);
			//qDebug () << "delete " << i;
		}
//		target->freeFieldList();
//		target->freeResources();
//		delete target;
		delete target;
		return true;
	}
	return false;
}
bool eWallet::_updateTarget(Target* target)
{
	////qDebug () << "UPDATE ON " << i;

	if (::dbManager->updateTarget(target)) {
		::dbManager->updateFields (target);
		
		target->freeFieldList();

		if (isShowGroups == 2) {
			int i = list.indexOf(target);
			QListWidgetItem* listitem = fnListWidget->item (i);
			listitem->setText(target->name);
		}
		else {
			showGroups(true);
		}
		return true;
	}
	return false;
}

bool eWallet::_updateTargetPicture(Target* target)
{
	////qDebug () << "UPDATE ON " << i;
	if (::dbManager->updateTargetPicture(target)) {
		if (isShowGroups == 2) {
			int i = list.indexOf(target);
			QListWidgetItem* listitem = fnListWidget->item (i);
			listitem->setIcon(getImage(target));
		}
		return true;
	}
	return false;
}
bool eWallet::_updateTargetPictureBack(Target* target)
{
	if (::dbManager->updateTargetPictureBack(target)) {
		return true;
	}
	return false;
}

void eWallet::deleteTarget(Target * target) {
	if (_deleteTarget (target)) {
		//delete target;
	}
}

void eWallet::windowDestroyedExtra(QObject* obj) {
    disconnect(obj, SIGNAL(destroyed(QObject*)),
               this, SLOT(windowDestroyedExtra(QObject*)));

	delete extraWindow;
	extraWindow = 0;

	//qDebug () << "WINDOW DESTROYED YES";

	showGroups (true);
}

void eWallet::windowDestroyed(QObject* obj)
{
    disconnect(obj, SIGNAL(destroyed(QObject*)),
               this, SLOT(windowDestroyed(QObject*)));

	delete detailWindow;
	detailWindow = 0;
 }
void eWallet::windowDestroyedEdit(QObject* obj)
{
    disconnect(obj, SIGNAL(destroyed(QObject*)),
               this, SLOT(windowDestroyedEdit(QObject*)));

	delete detailWindowEdit;
	detailWindowEdit = 0;

	if (isShowGroups == 1) {
		showGroups(true);
	}
	else {
		grouplist.clear ();
		grouplist = ::dbManager->getGroups ();

		if (grouplist.size() >= 1 && isFirst) {
			if (grouplist.size() > 1 || grouplist.at(0).length() > 0) {
				isShowGroups = 1;
				showGroups(true);
			}
		}
	}

}

void eWallet::viewTarget(Target * rent) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull()) detailWindow->raise();
		else
		if (!detailWindowEdit.isNull()) detailWindowEdit->raise();
		return ;
	}
#endif
	dbManager->getFields(rent);

	if (detailWindow.isNull()) {
		detailWindow = new DetailWindow(rent, "", 0, false, this, this);

		connect(detailWindow, SIGNAL(editTarget(Target*)), this, SLOT(editTarget(Target*)));
		connect(detailWindow, SIGNAL(newLikeTarget(Target*)), this, SLOT(newLikeTarget(Target*)));
		connect(detailWindow, SIGNAL(duplicateTarget(Target*)), this, SLOT(duplicateTarget(Target*)));
		connect(detailWindow, SIGNAL(newTarget()), this, SLOT(newTarget()));

        detailWindow->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindow, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
		//detailWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
	    detailWindow->show(); //owMaximized();
	}
}

void eWallet::import() {
	QString path(QDesktopServices::storageLocation(QDesktopServices::HomeLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                tr("Choose import file"),
	                path,
	                tr("Text files (*.txt);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (!s.isNull () && !s.isEmpty ()) {
		  QFile file(s);
		  QString line;

		  Target * target = NULL;
		  if ( file.open(QIODevice::Text | QIODevice::ReadOnly) ) {
		    // file opened successfully
		    QTextStream t(&file);        // use a text stream
		    // until end of file...
		    int i = 0;
		    while ( !t.atEnd() ) {
		      // read and parse the command line
		      QString line = t.readLine();         // line of text excluding '\n'
		      // do something with the line

		      if (line.length() > 0) {
		    	  if (target == NULL) {
		    		  target = new Target ();
		    	  }

		    	  int j = line.indexOf(QChar(':'));
		    	  if (j > 0) {
					  switch (i++) {
					  case 0:
						  target->name = line.mid(j + 1).trimmed();
						  break;
					  case 1:
						  target->groupName = line.mid(j + 1).trimmed();
						  break;
					  case 2:
						  // TODO check type with existing one!
						  target->type = line.mid(j + 1).trimmed();
						  break;
					  default:
						  TargetField * field = new TargetField ();

				    	  int jj = line.mid (0, j).indexOf(QChar(';'));
				    	  if (jj >= 0) {
							  field->name = line.mid (0, jj).trimmed();

			    			  int type = TYPE_STRING;
			    			  switch (line.at(jj + 1).toAscii()) {
								  case 'T':
									  type = TYPE_TEXT;
									  break;
								  case 'D':
									  type = TYPE_DATE;
									  break;
								  case 'U':
									  type = TYPE_URL;
									  break;
								  case 'P':
									  type = TYPE_PASSWORD;
									  break;
								  case 'N':
									  type = TYPE_INTEGER;
									  break;
								  case 'H':
									  type = TYPE_PHONE_NUMBER;
									  break;
								  case 'S':
								  default:
					    			  type = TYPE_STRING;
			    			  }
			    			  field->type = type;
				    	  }
				    	  else {
							  field->name = line.mid (0, j).trimmed();

//							  if (field->name.contains("url", Qt::CaseInsensitive)) {
//								  field->type = TYPE_URL;
//							  }
//							  else
//							  if (field->name.contains("password", Qt::CaseInsensitive)) {
//								  field->type = TYPE_PASSWORD;
//							  }
//							  else
//							  if (field->name.contains("pin", Qt::CaseInsensitive)) {
//								  field->type = TYPE_PASSWORD;
//							  }
//							  else
//							  if (field->name.contains("phone", Qt::CaseInsensitive)) {
//								  field->type = TYPE_PHONE_NUMBER;
//							  }
//							  else
//							  if (field->name.contains("number", Qt::CaseInsensitive)) {
//								  field->type = TYPE_INTEGER;
//							  }
//							  else
//							  if (field->name.contains("date", Qt::CaseInsensitive)) {
//								  field->type = TYPE_DATE;
//							  }
//							  else
//							  if (field->name.contains("note", Qt::CaseInsensitive)) {
//								  field->type = TYPE_TEXT;
//							  }
//							  else
								  field->type = TYPE_STRING;
				    	  }
						  field->value = line.mid(j + 1).trimmed();
						  field->order = 10 * (i - 3);
						  field->encrypted = true;

						  target->fields.append(field);
					  }

					  ////qDebug () << line << " | " << line.mid(j + 1) << " IS " << line.mid (0, j);
		    	  }
		    	  else {
		    		  if (target != NULL && target->fields.size() > 0) {
		    			  target->fields.last()->value.append("\n").append (line);
		    			  target->fields.last()->type = TYPE_TEXT;
		    		  }
		    	  }
		      }
		      else {
		    	  if (target != NULL) {
		    		  this->__insertTarget(target);
		    		  {
						QString imgPath = QFileInfo (s).absolutePath();
						imgPath += "/";
						imgPath += target->name.simplified().replace(' ', '_');
						imgPath += ".png";

						//qDebug () << "checking image " << imgPath;

						QFile imgFile (imgPath);
						if (imgFile.exists()) {
							QImage * currentImageN = new QImage ();
							DetailWindow::loadImage(imgPath, *currentImageN); //;
							target->setPicture(currentImageN);

							::dbManager->updateTargetPicture (target);
						}
		    		  }
		    		  {
						QString imgPath = QFileInfo (s).absolutePath();
						imgPath += "/";
						imgPath += target->name.simplified().replace(' ', '_');
						imgPath += "_BACK.png";

						//qDebug () << "checking image " << imgPath;

						QFile imgFile (imgPath);
						if (imgFile.exists()) {
							QImage * currentImageN = new QImage ();
							DetailWindow::loadImage(imgPath, *currentImageN); //;
							target->setPictureBack(currentImageN);

							::dbManager->updateTargetPictureBack (target);
						}
		    		  }
		    	  }
		    	  target = NULL;
		    	  i = 0;
		      }

		      QApplication::instance()->processEvents();

		      ////qDebug () << line;
		    }

			 if (target != NULL) {
				  this->__insertTarget(target);
			 }
		    // Close the file
		    file.close();

		    showInfo (true);
		  }
	}
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::renameGroup () {

	if (fnListWidget->currentRow() > 0) {
		QString target = grouplist.at(fnListWidget->currentRow() - 1);

		RenameGroupDialog * dialog = new RenameGroupDialog (this);
		dialog->setName(target);
		dialog->exec();
		QString newName = dialog->getName();

		//qDebug () << "NEW GROUP NAME " << target << " TO " << newName;

		delete dialog;

		if (::dbManager->renameGroup(target, newName)) {
			grouplist.clear ();
			grouplist = ::dbManager->getGroups ();

			if (grouplist.size() > 1) {
				showGroups(false);
			}
			else {
				if (grouplist.size() == 1 && grouplist.at(0).length () > 0) {
					showGroups(false);
				}
				else {
					isShowGroups = 2;
					showTargets(true, NULL);
				}
			}
		}

	}
}

void eWallet::deleteGroup () {
	if (fnListWidget->currentRow() > 0) {
		QString target = grouplist.at(fnListWidget->currentRow() - 1);

		if (::dbManager->deleteGroup(target)) {
			grouplist.clear ();
			grouplist = ::dbManager->getGroups ();

			if (grouplist.size() > 1) {
				showGroups(false);
			}
			else {
				if (grouplist.size() == 1 && grouplist.at(0).length () > 0) {
					showGroups(false);
				}
				else {
					isShowGroups = 2;
					showTargets(true, NULL);
				}
			}
		}

	}
}

void eWallet::contextMenuEvent (QContextMenuEvent * event) {
	//qDebug () << "Should be show " << this->childAt(event->globalPos());
	if (isAskPassword) {

	}
	else {
		if (isShowGroups == 1) {
			if (fnListWidget->currentRow() > 0) {
				QMenu menu(this);
				//menu.addAction(tr("View"), this, SLOT(_viewcTarget()));
				menu.addAction(tr("Rename"), this, SLOT(renameGroup()));
				menu.addAction(tr("Delete"), this, SLOT(deleteGroup()));
				menu.exec(event->globalPos());
			}
		}
		else {
			if (fnListWidget->currentRow() >= 0) {
				//Target * target = list.at(fnListWidget->currentRow());

				QMenu menu(this);
				menu.addAction(tr("View"), this, SLOT(_viewcTarget()));
				menu.addAction(tr("Edit"), this, SLOT(_editcTarget()));
				menu.addAction(tr("New like this"), this, SLOT(_newLikeTarget()));
				menu.addAction(tr("Duplicate"), this, SLOT(_duplicateTarget()));
				menu.addAction(tr("Delete"), this, SLOT(_deletecTarget()));
				menu.exec(event->globalPos());
			}
		}
	}
}

void eWallet::exportData() {
	QString path(QDesktopServices::storageLocation(QDesktopServices::HomeLocation));

	path.append("/wallet_export.txt");

	QString s = QFileDialog::getSaveFileName(
	                this,
	                tr("Choose export file"),
	                path,
	                tr("Text files (*.txt);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	if (!s.isNull () && !s.isEmpty ()) {
		if (!s.endsWith(".txt"))
			s.append(".txt");

		  QFile file(s);

		  if ( file.open(QIODevice::Text | QIODevice::WriteOnly) ) {
		    // file opened successfully
		    QTextStream t(&file);        // use a text stream

		    QList<Target *> list = ::dbManager->getTargets(NULL);

			for (int i = 0; i < list.size (); i++) {
				Target * target = list[i];

				QImage * img = target->getPicture();

				if (img != NULL) {
					QString imgPath = QFileInfo (s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += ".png";

					//qDebug () << "exporting image " << imgPath;

					img->save(imgPath, "PNG"); // writes image into ba in PNG format
				}

				img = target->getPictureBack();

				if (img != NULL) {
					QString imgPath = QFileInfo (s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += "_BACK.png";

					//qDebug () << "exporting back image " << imgPath;

					img->save(imgPath, "PNG"); // writes image into ba in PNG format
				}

				t << "Name: " << target->name << "\n";
				t << "Group Name: " << target->groupName << "\n";
				t << "Type: " << target->type << "\n";

				dbManager->getFields(target);

				TargetField * field;
				foreach(field, target->fields) {
	    			  switch (field->type) {
						  case TYPE_TEXT:
							t << field->name << ";T: " << field->value << "\n";
							  break;
						  case TYPE_DATE:
								t << field->name << ";D: " << field->value << "\n";
							  break;
						  case TYPE_URL:
								t << field->name << ";U: " << field->value << "\n";
							  break;
						  case TYPE_PASSWORD:
								t << field->name << ";P: " << field->value << "\n";
							  break;
						  case TYPE_INTEGER:
								t << field->name << ";N: " << field->value << "\n";
							  break;
						  case TYPE_PHONE_NUMBER:
								t << field->name << ";H: " << field->value << "\n";
							  break;
						  case 'S':
						  default:
								t << field->name << ": " << field->value << "\n";
	    			  }
				}

				t << "\n\n";

				target->freeFieldList();
				target->freeResources();

				QApplication::instance()->processEvents();

				delete target;
			}

			list.clear();

		    // Close the file
		    file.close();
		  }
	}
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::editTarget(Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull()) detailWindow->raise();
		else
		if (!detailWindowEdit.isNull()) detailWindowEdit->raise();
		return ;
	}
#endif

	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target, "", 0, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyedEdit(QObject*)));
        detailWindowEdit->show();
	}
}

void eWallet::duplicateTarget (Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull()) detailWindow->raise();
		else
		if (!detailWindowEdit.isNull()) detailWindowEdit->raise();
		return ;
	}
#endif

	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target, currentGroup != NULL ? *currentGroup : "", 2, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyedEdit(QObject*)));
        detailWindowEdit->show();
	}
}

void eWallet::newLikeTarget (Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull()) detailWindow->raise();
		else
		if (!detailWindowEdit.isNull()) detailWindowEdit->raise();
		return ;
	}
#endif
	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target, currentGroup != NULL ? *currentGroup : "", 1, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyedEdit(QObject*)));
        detailWindowEdit->show();
	}
}

void eWallet::newTarget() {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull()) detailWindow->raise();
		else
		if (!detailWindowEdit.isNull()) detailWindowEdit->raise();
		return ;
	}
#endif
	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(NULL, currentGroup != NULL ? *currentGroup : "", 0, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyedEdit(QObject*)));
        detailWindowEdit->show();
	}
}


void eWallet::_newLikeTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(fnListWidget->currentRow()))) return;
		Target * target = list.at(fnListWidget->currentRow());
		newLikeTarget (target);
	}
}

void eWallet::_duplicateTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(fnListWidget->currentRow()))) return;
		Target * target = list.at(fnListWidget->currentRow());
		duplicateTarget (target);
	}
}

void eWallet::_editcTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(fnListWidget->currentRow()))) return;
		Target * target = list.at(fnListWidget->currentRow());
		editTarget(target);
	}
}
void eWallet::_deletecTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(fnListWidget->currentRow()))) return;
		Target * target = list.at(fnListWidget->currentRow());
		deleteTarget(target);
	}
}
void eWallet::_viewcTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(fnListWidget->currentRow()))) return;
		Target * target = list.at(fnListWidget->currentRow());
		viewTarget(target);
	}
}

void eWallet::closeEvent(QCloseEvent *event){
	event->accept();
}

void eWallet::askPassword () {
	setContextMenuPolicy(Qt::NoContextMenu);

	times = 0;
	
	isAskPassword = true;
	isChangingPassword = false;
	createMenu();

	bool firstTime = !::dbManager->hasPassword ();
#ifdef Q_WS_MAEMO_5
	if (firstTime) {
		show_information_note (this, tr("Please, enter a password for your wallet"));
	}
	else {
		show_banner (this, tr("Please, enter the password to unlock your wallet"));
	}
#endif

	if (loginDialogDlg.isNull()) {
		loginDialogDlg = new LoginDialog(firstTime, this);
		setCentralWidget(loginDialogDlg);
	}
	loginDialogDlg->focus ();
}

void eWallet::about() {
	QMessageBox::about(this, tr("About Wallet"), tr("<qt><br><br><p><i><b>qtWallet</b></i>, v.1.0</p>"\
			"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"\
			"<p>Icons by http://pixelmixer.ru/</p>"\
			"<p>if you think that qtWallet is useful for you, please</p>"\
			"<a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtWallet&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted\">DONATE</a></qt>").arg(VERSION));
}

bool eWallet::finalPassword (const QString & pass) {
	if (isChangingPassword)
		reallyChangePassword(pass);
	else
		return openDataBase (pass);

	return false;
}

void eWallet::changePassword () {
	times = 0;
	isChangingPassword = true;
	isAskPassword = true;

	createMenu();

	if (loginDialogDlg.isNull()) {
		loginDialogDlg = new LoginDialog(true, this);
		setCentralWidget(loginDialogDlg);
		setFocus ();
		loginDialogDlg->setFocus();
		focusNextChild();
	}

}


 class MyThread : public QThread
 {
	 public:
	 QString p;
	 QString newPassword;

	 void run() {
		//sleep(2000);

		p = ::dbManager->changePassword(newPassword);
	 }

 };


void eWallet::reallyChangePassword (const QString & newPassword) {
	showList (false);

//	QMessageBox * messageBox = new QMessageBox (this);
//	messageBox->information(this, "Wallet", tr("Changing password, please wait until application quits"), QMessageBox::Ok);

	//show_information_note (NULL, tr("Changing password, please wait until application quits"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	MyThread t;
	t.newPassword = newPassword;
	t.start ();
//	t.wait ();

	while (t.isRunning()){
#ifdef Q_WS_MAEMO_5
		show_banner (this, tr("Changing password, please wait until application quits"));
#endif
		QApplication::instance()->processEvents();
		t.wait (2000);
	}

	QString p = t.p; // ::dbManager->changePassword(newPassword);

#ifndef Q_WS_MAEMO_5
	QMessageBox * messageBox = new QMessageBox (this);
#endif
	if (p.length() == 0)
#ifndef Q_WS_MAEMO_5
		messageBox->information(this, "Wallet", tr("Password changed successfully, application will exit"), QMessageBox::Ok);
#endif
#ifdef Q_WS_MAEMO_5
		show_information_note (NULL, tr("Password changed successfully, application will exit"));
#endif
	else {
#ifndef Q_WS_MAEMO_5
		messageBox->information(this, "Wallet", tr("Password CANNOT BE changed, because %1, and application will exit").arg(p) , QMessageBox::Ok);
#endif
#ifdef Q_WS_MAEMO_5
		show_information_note (NULL, tr("Password CANNOT BE changed, because %1, and application will exit").arg(p));
#endif
	}

	delete messageBox;

	//delete ::dbManager;
	//exit (3);
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

	::dbManager->close ();
	openDataBase (newPassword);

//	::dbManager->lock ();
//	askPassword ();
}


