/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef EWALLET_H
#define EWALLET_H

#include <QtGui>
#include <QDebug>

#include "DatabaseManager.h"
#include "QFNListWidget.h"
#include "CreateTargetDialog.h"
#include "DetailedWindow.h"
#include "LoginDialog.h"

#define TYPE_TEXT 3
#define TYPE_DATE 2
#define TYPE_STRING 0
#define TYPE_INTEGER 1

extern DatabaseManager * dbManager;

class eWallet: public QMainWindow
{
	Q_OBJECT

public:
	eWallet (QWidget *parent = 0);
	~eWallet ();

	void keyPressEvent(QKeyEvent*);
	void timerEvent(QTimerEvent*);

	bool openDataBase (QString pas);

	bool _deleteTarget(Target* target);
	bool _updateTarget(Target* target);
	bool _updateTargetPicture(Target* target);
	bool _updateTargetPictureBack(Target* target);
	bool _insertTarget(Target* target);
	
	QList<QString> types;
	QList<QList<TargetField>*> fieldsByType;

public slots:
	void newTarget();
	void import();
	void editTarget(Target * t);
	void deleteTarget(Target * t);
	void viewTarget(Target * t);

private:
	void createMenu();
	void showTargets();
	void loadTypesAndFields ();
	//void contextMenuEvent (QContextMenuEvent * event);

private slots:
    void windowDestroyed(QObject* obj = 0);
	void _editcTarget();
	void _deletecTarget();
	void _viewcTarget();
	void lockWallet ();
	
private:
	//void timerEvent(QTimerEvent *event);
	void askPassword ();
	void closeEvent(QCloseEvent *event);
	
	QVBoxLayout* vboxlayout;

	QFNListWidget* fnListWidget;
	QList<Target *> list;

	QPointer<CreateTargetDialog> createTargetDlg;
	QPointer<LoginDialog> loginDialogDlg;
	QPointer<DetailWindow> detailWindow;
	QPointer<DetailWindow> detailWindowEdit;
	QWidget* centralWidget;
	QPointer <QMessageBox> messageBox;
	bool opendb;
	bool initdb;
	
	int row;
	
	QTimer *timer;
};
#endif // EWALLET_H
