/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "eWallet.h"
#include "Constants.h"
#include "DetailedWindow.h"
#include <Qt>
#include <QDesktopServices>
//#include <QtXml>
//#include <QXmlSimpleReader>


DetailWindow::DetailWindow(Target * target, bool edit, eWallet *paTarget, QWidget *parent) :
		QMainWindow(parent)
{
	isNew = target == NULL;

	this->target = target;
	this->parent = paTarget;
	this->edit = edit;

	if (isNew) {
		this->target = new Target ();
		this->target->type = this->parent->types[0];
		changeFields (0);
	}

	orgType = this->target->type;

	deleteFace = false;
	deleteBack = false;

	currentImageN = NULL;
	currentImageBackN = NULL;

	if (target) {
		currentImage = target->getPicture();
		currentImageBack = target->getPictureBack();
	}
	else {
		currentImage = NULL;
		currentImageBack = NULL;
	}


	if (edit) {
		menuBar()->addAction("Save", this, SLOT(saveTarget()));
		if (!isNew)
			menuBar()->addAction("Delete", this, SLOT(_deleteTarget()));
		menuBar()->addAction("Change Face Pict.", this, SLOT(cardFace()));
		menuBar()->addAction("Change Back Pict.", this, SLOT(cardBack()));
		menuBar()->addAction("Delete Face Pict.", this, SLOT(deleteCardFace()));
		menuBar()->addAction("Delete Back Pict.", this, SLOT(deleteCardBack()));
	}
	else {
		menuBar()->addAction("New", this, SLOT(_newTarget()));
		menuBar()->addAction("Edit", this, SLOT(_editTarget()));
		menuBar()->addAction("Export Face Pict.", this, SLOT(exportCardFace()));
		menuBar()->addAction("Export Back Pict.", this, SLOT(exportCardBack()));
	}
	
	centralWidget = new QWidget(this);

	centralWidget->setContextMenuPolicy(Qt::CustomContextMenu);

	vboxlayout = new QVBoxLayout ();
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);
	// Custom list box
	//fnListWidget = new QFNListWidget(this);
	//vboxlayout->addWidget(fnListWidget);

	//QFrame * entryFrame = new QFrame(this);
	//entryFrame->setContextMenuPolicy(Qt::NoContextMenu);

	entryScrollArea = new QScrollArea;
	//entryScrollArea->setProperty("FingerScrollable", false);
	entryScrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	//entryFrame->setProperty("FingerScrollable", false);
	//entryScrollArea->setPalette(*p);
	//entryScrollArea->setFocusPolicy(Qt::NoFocus);
	//entryScrollArea->setContextMenuPolicy(Qt::NoContextMenu);
	entryScrollArea->setWidgetResizable(true);
	entryScrollArea->setWidget(centralWidget);
	entryScrollArea->setProperty("FingerScrollable", true);

	centralWidget->setLayout(vboxlayout);
	setCentralWidget(entryScrollArea);

	// Create layout for the ui controls
	componentLayout = new QGridLayout ();
	//componentLayout->setContentsMargins(15, 0, 15, 0);
	//componentLayout->setSpacing(5);
	// Name label
	if (edit) {
		QLabel * nameLabel = new QLabel("Name", this);
		//nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
		componentLayout->addWidget(nameLabel, 1, 1, 1, 2);

	    nameLineEdit = new QLineEdit(this);
		//nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
		//nameLineEdit->setAlignment(Qt::AlignTop);
		componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);
		if (target)
			nameLineEdit->setText (target->name);
	}
	else {
		this->setWindowTitle (target->name);
		/*
		QLabel * nameLineEdit = new QLabel(target->name, this);
		nameLineEdit->setContextMenuPolicy(Qt::NoContexnameLineEdittMenu);
		componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);*/
	}

	if (edit) {
		// type label
		QLabel * typeLabel = new QLabel("Type", this);
		//typeLabel->setContextMenuPolicy(Qt::NoContextMenu);
		componentLayout->addWidget(typeLabel, 2, 1, 1, 2);

		typeLineEdit = new QComboBox(this);

		bool selected = false;
		for(int i = 0; i < this->parent->types.size(); i++) {
			typeLineEdit->addItem (this->parent->types[i], this->parent->types[i]);
			if (target)
				if (target->type == this->parent->types[i]) {
					typeLineEdit->setCurrentIndex(i);
					selected = true;
				}
		}
		if (!selected) {
			typeLineEdit->setCurrentIndex(this->parent->types.size() - 1);
		}

	    connect(typeLineEdit, SIGNAL(activated(int)), this, SLOT(emitCommitData(int)));


		//typeLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
		//typeLineEdit->setAlignment(Qt::AlignTop);
		componentLayout->addWidget(typeLineEdit, 2, 3, 1, 4);
		//typeLineEdit->setText (target->type);
	}
	else {
/*		// type label
		QLabel * typeLabel = new QLabel("Type", this);
		typeLabel->setContextMenuPolicy(Qt::NoContextMenu);
		componentLayout->addWidget(typeLabel, 2, 1, 1, 2);

		QLabel * typeLineEdit = new QLabel (target->type, this); //QLineEdit(this);
		typeLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
		componentLayout->addWidget(typeLineEdit, 2, 3, 1, 4);*/
	}

	vboxlayout->addLayout(componentLayout);

	componentLayout = new QGridLayout ();

	setContextMenuPolicy(Qt::CustomContextMenu);
	QObject::connect(this, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardMenu(const QPoint&)));
	//QObject::connect(centralWidget, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardFaceMenu(const QPoint&)));

	if (edit || target->getPicture() != NULL) {
		imageLabel = new QLabel(this);
		imageLabel->setContextMenuPolicy(Qt::CustomContextMenu);
		imageLabel->setBackgroundRole(QPalette::NoRole);
		imageLabel->setScaledContents(true);
		if (edit) imageLabel->setMaximumSize(250, 200);
		if (currentImage == NULL) {
			QPixmap available(":/resources/empty_card.png");
			imageLabel->setPixmap(available);
		}
		else {
			imageLabel->setPixmap(QPixmap::fromImage (*currentImage));
		}
		
		QObject::connect(imageLabel, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardFaceMenu(const QPoint&)));
		if (edit) {
			componentLayout->addWidget(imageLabel, 3, 1, 2, 3);
		}
		else
			vboxlayout->addWidget(imageLabel); //, 0, 0, 1, 1);
	}
	else {
		imageLabel = NULL;
	}

	if (edit || target->getPictureBack() != NULL) {
		imageBackLabel = new QLabel(this);
		imageBackLabel->setContextMenuPolicy(Qt::CustomContextMenu);
		imageBackLabel->setBackgroundRole(QPalette::NoRole);
		imageBackLabel->setScaledContents(true);
		//imageBackLabel->setFocusPolicy(Qt::StrongFocus);
		if (edit) imageBackLabel->setMaximumSize(250, 200);
		if (currentImageBack == NULL) {
			QPixmap availableBack(":/resources/empty_card_back.png");
			imageBackLabel->setPixmap(availableBack);
		}
		else {
			imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBack));
		}

		QObject::connect(imageBackLabel, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardBackMenu(const QPoint&)));
		if (edit) {
			componentLayout->addWidget(imageBackLabel, 3, 4, 2, 3);
		}
		else
			vboxlayout->addWidget(imageBackLabel); //, 1, 0, 1, 1);
	}
	else {
		imageBackLabel = NULL;
	}

	if (edit) {
		vboxlayout->addLayout(componentLayout);
		componentLayout = new QGridLayout ();
	}

	showFields ();

	vboxlayout->addLayout(componentLayout);
}

void DetailWindow::showFields () {

	if (edit) {
		//QObjectList list = componentLayout->children();

		for (int i = 0; i < this->labels.size(); i++) {
			componentLayout->removeWidget(this->labels[i]);
			delete this->labels[i];
		}

		for (int i = 0; i < this->values.size(); i++) {
			componentLayout->removeWidget(this->values[i]);
			delete this->values[i];
		}

		//qDebug () << " list elements " << list.size();

		this->values.clear();
		this->labels.clear();
	}

	int pos = 0;
	if (target) {
		TargetField * field;
		foreach(field, target->fields) {
			if (edit) {
	/*			QLabel * nameLabel = new QLabel(field->name, this);
				nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
				componentLayout->addWidget(nameLabel, pos+1, 1, 1, 2);
*/
				QLineEdit * nameLabel = new QLineEdit(this);
				//nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
				componentLayout->addWidget(nameLabel, pos + 1, 1, 1, 2);
				nameLabel->setText (field->name);

				QLineEdit * nameLineEdit = new QLineEdit(this);
				//nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
				componentLayout->addWidget(nameLineEdit, pos + 1, 3, 1, 4);
				nameLineEdit->setText (field->value);
				
				this->labels.append (nameLabel);
				this->values.append (nameLineEdit);
			}
			else {
				if (field->value.length() > 0) {
					QLabel * nameLabel = new QLabel(field->name, this);
					//nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
					componentLayout->addWidget(nameLabel, pos + 1, 1, 1, 2);

					QLabel * nameLineEdit = new QLabel(field->value, this);
					//nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
					componentLayout->addWidget(nameLineEdit, pos + 1, 3, 1, 4);

					//this->labels.append (nameLabel);
					//this->labels.append (nameLineEdit);
				}
			}
			pos++;
		}
	}
	
/*	if (edit) {
		for (int i = 0; i < 5; i++) {
			QLineEdit * nameLabel = new QLineEdit(this);
			nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
			componentLayout->addWidget(nameLabel, pos+1, 1, 1, 2);
			//nameLabel->setText (field->name);
			
			QLineEdit * nameLineEdit = new QLineEdit(this);
			nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
			componentLayout->addWidget(nameLineEdit, pos+1, 3, 1, 4);
			//nameLineEdit->setText (field->value);

			this->labels.append (nameLabel);
			this->values.append (nameLineEdit);
			pos++;
		}
	}*/
}

void DetailWindow::changeFields (int a) {

	//qDebug () << "selectedt " << a;

	for (int i = target->fields.size(); i > 0; i--) {
		TargetField * field = target->fields [i - 1];

		if (field->value.length() == 0) {
			target->fields.removeAt(i - 1);
			delete field;
		}
	}

	for (int i = 0; i < parent->fieldsByType [a]->size(); i++) {
		TargetField tmp = parent->fieldsByType [a]->at(i);

		if (!target->existField (tmp.name)) {
			TargetField * f;

			f = new TargetField ();
			f->name = tmp.name;
			f->encrypted = tmp.encrypted;
			f->value = "";
			f->type = tmp.type;
			f->order = tmp.order;

			target->fields.append(f);
		}

	}
}

void DetailWindow::emitCommitData (int a) {
	changeFields (a);
	showFields();
}

DetailWindow::~DetailWindow () {
	target->freeResources();

	if (currentImageBackN) delete currentImageBackN;
	if (currentImageN) delete currentImageN;

}

void DetailWindow::saveTarget () {
	if (nameLineEdit->text().length() < 1) {
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", "Card description is missing", QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
		return;
	}

	 if (typeLineEdit->currentIndex() < 0) {
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", "Type card is missing", QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
		return;
	}
	
	if (target == NULL) {
		this->target = new Target ();
	}


	this->target->name = nameLineEdit->text();
	this->target->type = typeLineEdit->itemData(typeLineEdit->currentIndex()).toString();
	
	//qDebug () << "getting fields ";

	for (int i = 0; i < target->fields.count(); i++) {
		TargetField * field = target->fields[i];
		//qDebug () << "getting field " << i;
		
		field->name = labels[i]->text();
		field->value = values[i]->text();
	}
/*
	//qDebug () << "getting extra fields ";
	int M = target->fields.count();
	for (int i = 0; i < 5; i++) {
		//qDebug () << "getting extra field " << i;
		if (labels[i + M]->text().length () > 0) {
			//qDebug () << "getting new extra field " << i;

			TargetField * field = new TargetField ();
			
			field->id = -1;
			field->name = labels[i + M]->text();
			field->value = values[i + M]->text();
			field->type = 1; // TODO
			field->encrypted = 1; // TODO

			this->target->fields.append(field);
		}
		else {
			if (values[i + M]->text().length () > 0) {
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet", "All fields must have a name", QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;
				return;
			}
		}
	}
*/
	if (isNew) {
		parent->_insertTarget(this->target);
	}
	else {
		parent->_updateTarget(this->target);
	}

	if (deleteFace) {
		qDebug () << "DELETE FACE";
		target->setPicture (NULL);
		parent->_updateTargetPicture(target);
	}
	else
	if (currentImageN) {
		target->setPicture (currentImageN);
		currentImageN = NULL;
		parent->_updateTargetPicture(target);
	}
	else {
		if (orgType != target->type && target->getPicture() == NULL) {
			parent->_updateTargetPicture(target);
		}
	}


	if (deleteBack) {
		qDebug () << "DELETE BACK";
		target->setPictureBack (NULL);
		parent->_updateTargetPictureBack(target);
	}
	else
	if (currentImageBackN) {
		target->setPictureBack (currentImageBackN);
		currentImageBackN = NULL;
		parent->_updateTargetPictureBack(target);
	}

	close();
}

void DetailWindow::_deleteTarget () {
	if (target) {
		parent->deleteTarget(target);
	}

	close();
}

void DetailWindow::_editTarget () {
	emit editTarget(target);

	close ();
}

void DetailWindow::_newTarget () {

	emit newTarget();

	close ();
}

void DetailWindow::loadImage (QString q, QImage& res) {
	QImageReader reader;
	// Set image name
/*	QString path(QDir::home().path());
	path.append(QDir::separator()).append("photo.png");
	path = QDir::toNativeSeparators(path);
*/
	reader.setFileName(q);
	//Set/scale image size into screen
	QSize imageSize = reader.size();
	QSize ss (INTERNAL_WIDTH, INTERNAL_HEIGH);
	imageSize.scale(ss, Qt::KeepAspectRatio);
	reader.setScaledSize(ss);
	// Read image
	res = reader.read();
	//qDebug () << "read " << q << " as (" << imageSize << ") with result " << reader.errorString ();
}

void DetailWindow::cardMenu(const QPoint & _p) {
	QPoint p = this->mapFromGlobal(_p);

	QScrollBar* bar = entryScrollArea->verticalScrollBar();
	if (bar)
		p.setY(p.y() + bar->value());

	entryScrollArea->ensureVisible(p.x(), p.y());

	if (this->imageLabel != NULL && this->imageLabel->geometry().contains(p)) {
		QMenu menu(this);
		if (edit) {
			menu.addAction("Edit", this, SLOT(cardFace()));
			menu.addAction("Delete", this, SLOT(deleteCardFace()));
		}
		else {
			menu.addAction("Export", this, SLOT(exportCardFace()));
		}
		menu.exec(_p);
	}
	else
	if (this->imageBackLabel != NULL && this->imageBackLabel->geometry().contains(p)) {
		QMenu menu(this);
		if (edit) {
			menu.addAction("Edit", this, SLOT(cardBack()));
			menu.addAction("Delete", this, SLOT(deleteCardBack()));
		}
		else {
			menu.addAction("Export", this, SLOT(exportCardBack()));
		}
		menu.exec(_p);
	}
}
void DetailWindow::deleteCardFace()
{
	QPixmap available(":/resources/empty_card.png");
	imageLabel->setPixmap(available);

	deleteFace = true;
}
void DetailWindow::exportCardFace()
{
	if (target->picture != NULL) {
		QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
		QString s = QFileDialog::getSaveFileName(
	                this,
	                "Choose card face image file",
	                path,
	                "Images (*.png)");
		if (!s.isNull () && !s.isEmpty ()) {
			s.append(".png");
			target->picture->save(s, "PNG"); // writes image into ba in PNG format
		}
	}
}
void DetailWindow::cardFace()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose card face image",
	                path,
	                "Images (*.png *.jpg)");

	if (!s.isNull () && !s.isEmpty ()) {
		//qDebug () << "loading " << s;
		if (currentImageN) delete currentImageN;

		/*QImage * tmp = new QImage (s);
		currentImageN = new QImage ();
		*currentImageN = tmp->scaled (INTERNAL_WIDTH, INTERNAL_HEIGH);
		delete tmp;
		*/
		currentImageN = new QImage ();
		loadImage(s, *currentImageN); //;
		//qDebug () << "loaded " << s;
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		//qDebug () << "asigned " << s;
		//update();
		deleteFace = false;
	}
}
void DetailWindow::cardBackMenu(const QPoint & pos) {

	qDebug () << "MENU";

	QMenu menu(this);
	if (edit) {
		menu.addAction("Edit", this, SLOT(cardBack()));
		menu.addAction("Delete", this, SLOT(deleteCardBack()));
	}
	else {
		menu.addAction("Export", this, SLOT(exportCardBack()));
	}
	menu.exec(pos);
}
void DetailWindow::cardFaceMenu(const QPoint & pos) {

	qDebug () << "MENU";

	QMenu menu(this);
	if (edit) {
		menu.addAction("Edit", this, SLOT(cardFace()));
		menu.addAction("Delete", this, SLOT(deleteCardFace()));
	}
	else {
		menu.addAction("Export", this, SLOT(exportCardFace()));
	}
	menu.exec(pos);
}
void DetailWindow::deleteCardBack()
{
	QPixmap available(":/resources/empty_card_back.png");
	imageBackLabel->setPixmap(available);

	deleteBack = true;
}
void DetailWindow::exportCardBack()
{
	if (target->pictureBack != NULL) {
		QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
		QString s = QFileDialog::getSaveFileName(
	                this,
	                "Choose card back image file",
	                path,
	                "Images (*.png)");
		if (!s.isNull () && !s.isEmpty ()) {
			s.append(".png");
			target->pictureBack->save(s, "PNG"); // writes image into ba in PNG format
		}
	}
}
void DetailWindow::cardBack()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose card back image",
	                path,
	                "Images (*.png *.jpg)");
	if (!s.isNull () && !s.isEmpty ()) {
		//qDebug () << "loading " << s;
		if (currentImageBackN) delete currentImageBackN;
		
		/*QImage * tmp = new QImage (s);
		currentImageBackN = new QImage ();
		*currentImageBackN = tmp->scaled (INTERNAL_WIDTH, INTERNAL_HEIGH);
		delete tmp;
		*/
		currentImageBackN = new QImage ();
		loadImage(s, *currentImageBackN); //;
		
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		//update ();
		deleteBack = false;
	}
}
