/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef DATABASEMANAGER_H_
#define DATABASEMANAGER_H_

#include <QObject>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlQuery>
#include <QPixmap>
#include <QDate>
#include <QtGui>
#include <QDebug>

#include <openssl/aes.h>
// ---------------------------------------------------------------------------
// TargetField
// ---------------------------------------------------------------------------
class TargetField
{
public:
	TargetField() {
		id = -1;
	}
	~TargetField();

	TargetField(QString name, int type, bool encrypted, int order) {
		this->id = -1;
		this->name = name;
		this->type = type;
		this->encrypted = encrypted;
		this->order = order;
	}

	int id;
	int targetId;

	int order;
	bool encrypted;
	QString name;
	QString value;
	int type;
};
// ---------------------------------------------------------------------------
// target
// ---------------------------------------------------------------------------
class Target
{
public:
	Target();
	~Target();
	int id;
	QString name;
	QString groupName;
	QString type;

	QImage * getPictureSmall ();
	QImage * getPicture ();
	QImage * getPictureBack ();

	//void setPictureSmall (QImage * a);
	void setPicture (QImage * a);
	void setPictureBack (QImage * a);

	void freeResources ();
	void freeFieldList ();
	QString getSummary ();

	bool existField (QString name);
//private:
	QImage * pictureSmall;
	QImage * picture;
	QImage * pictureBack;

	QList<TargetField*> fields; // ?? * or not

	bool listLoaded;
};



// ---------------------------------------------------------------------------
// DatabaseManager
// ---------------------------------------------------------------------------
class DatabaseManager: public QObject
{
public:
	DatabaseManager(QObject *parent = 0);
	~DatabaseManager();

public:
	//bool sortTargets (const Target * f, const Target * g);

	bool openDB(QString pass);
	bool deleteDB();
	bool hasPassword ();
	bool isReady ();
	void lock ();
	void reset ();
	
	int nextId();

	bool insertTarget(Target* target);
	QList<Target*> getTargets(const QString & filter);
	QList<QString> getGroups ();

	bool deleteTarget(Target* target);
	bool updateTarget(Target* target);
	bool updateTargetPicture(Target* target);
	bool updateTargetPictureBack(Target* target);
	bool updateFields(Target* target);

	bool insertTargetField(TargetField* field);
	bool updateTargetField(TargetField* field);
	void getFields(Target * target);

	QSqlError lastError();	

	QImage * getPicture (Target * t);
	QImage * getPictureBack (Target * t);

	bool backupDB();

private:
	bool openDB();
	bool initDB();
	bool isInit();

	bool checkPassword (QString a);
	bool createPassword (QString a);

	bool createTargetTable();
	bool createIdTable();
	bool createTargetFieldTable();

	bool createTableVersion ();
	bool migrateVersion (int fromV, int toV);

	void encrypt (const QString a, QByteArray& b);
	void decrypt (const QByteArray& a, QString& b);

	void encrypt (const QByteArray& a, QByteArray& b);
	void decrypt (const QByteArray& a, QByteArray& b);
	QByteArray selectSecretPhrase();
	bool hasSecretPhrase();
	bool updateSecretPhrase(QByteArray a);

private:
	AES_KEY aeskeyE;
	AES_KEY aeskeyD;
	QSqlDatabase db;
	unsigned char key[32];
	int keyLen;
	
	bool opendb;
	bool initdb;
};

#endif /* DATABASEMANAGER_H_ */
