/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "eWallet.h"
#include "LoginDialog.h"
#include "Constants.h"

LoginDialog::LoginDialog(bool firstTime, eWallet *paTarget): QWidget((QWidget*)paTarget)
{
	setContextMenuPolicy(Qt::NoContextMenu);

	isFirstTime = firstTime;
	NTimes = 0;

	QHBoxLayout * layout = new QHBoxLayout(this);
	QGridLayout * componentLayout = new QGridLayout ();
	this->parent = paTarget;

	layout->setSpacing(0);
	layout->setMargin(10);

	componentLayout->setContentsMargins(20, 20, 20, 20);

	QPushButton * imageButton [12];

	QSignalMapper * signalMapper = new QSignalMapper(this);

	label = new QLineEdit("", this);
	label->setContextMenuPolicy(Qt::NoContextMenu);
	label->setEchoMode(QLineEdit::Password); //EchoOnEdit);
	//label->setFocus(Qt::TabFocusReason);
	label->setMaxLength(16);
	//label->setAlignment(Qt::AlignCenter);

	for (int i = 0; i < 12; i++) {
		QString text ('0' + i + 1);

		if (i == 9) {
			text = "Ok";
			imageButton[i] = new QPushButton(text, this); // QIcon(":/resources/icon_accept.png"),
			imageButton[i] ->setFixedHeight(70);
			imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
			imageButton[i] ->setFocusPolicy(Qt::NoFocus);
			//imageButton[i] ->setIconSize(QSize(20, 20));
			componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

			//signalMapper->setMapping(imageButton[i], text);

			QObject::connect(imageButton[i], SIGNAL(clicked()), this, SLOT(acceptS()));
		} else {
			if (i == 10) {
				text = "0";
				imageButton[i] = new QPushButton(text, this); // QIcon(":/resources/number.png"),
				imageButton[i] ->setFixedHeight(70);
				imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
				imageButton[i] ->setFocusPolicy(Qt::NoFocus);
				//imageButton[i] ->setIconSize(QSize(20, 20));
				componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

				signalMapper->setMapping(imageButton[i], text);

				QObject::connect(imageButton[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
			} else
				if (i == 11) {
					text = "Clear";
					imageButton[i] = new QPushButton(text, this); // QIcon(":/resources/icon_clear.png"),
					imageButton[i] ->setFixedHeight(70);
					imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
					imageButton[i] ->setFocusPolicy(Qt::NoFocus);
					//imageButton[i] ->setIconSize(QSize(20, 20));
					componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

					//signalMapper->setMapping(imageButton[i], text);

					QObject::connect(imageButton[i], SIGNAL(clicked()), this, SLOT(clearS()));
				} else {
					imageButton[i] = new QPushButton(text, this); // QIcon(":/resources/number.png"),
					imageButton[i] ->setFixedHeight(70);
					imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
					imageButton[i] ->setFocusPolicy(Qt::NoFocus);
					//imageButton[i] ->setIconSize(QSize(20, 20));
					componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

					signalMapper->setMapping(imageButton[i], text);

					QObject::connect(imageButton[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
				}
		}
	}

	componentLayout->addItem(new QSpacerItem(2,3), 4, 3, 3, 2);

	connect(signalMapper, SIGNAL(mapped(const QString &)),
	        this, SLOT(select(const QString &)));

	componentLayout->addWidget(label, 4, 0, 1, 4);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	QPushButton * aboutButton = new QPushButton(QIcon(":/resources/about.png"), "About", this);
	aboutButton->setFixedHeight(70);
	aboutButton->setContextMenuPolicy(Qt::NoContextMenu);
	aboutButton->setFocusPolicy(Qt::NoFocus);
	aboutButton->setIconSize(QSize(48, 48));
	QObject::connect(aboutButton, SIGNAL(clicked()), this, SLOT(about()));
	dlgBtnBox->addButton(aboutButton, QDialogButtonBox::ActionRole);

//	QPushButton * deleteButton = new QPushButton(QIcon(":/resources/delete.png"), "Delete DB", this);
//	deleteButton->setFixedHeight(70);
//	deleteButton->setContextMenuPolicy(Qt::NoContextMenu);
//	deleteButton->setFocusPolicy(Qt::NoFocus);
//	deleteButton->setIconSize(QSize(48, 48));
//	QObject::connect(deleteButton, SIGNAL(clicked()), this->parent, SLOT(deleteDB()));
//	dlgBtnBox->addButton(deleteButton, QDialogButtonBox::ActionRole);

	QPushButton * exitButton = new QPushButton(QIcon(":/resources/exit.png"), "Exit", this);
	exitButton->setFixedHeight(70);
	exitButton->setContextMenuPolicy(Qt::NoContextMenu);
	exitButton->setFocusPolicy(Qt::NoFocus);
	exitButton->setIconSize(QSize(48, 48));
	QObject::connect(exitButton, SIGNAL(clicked()), QApplication::instance(), SLOT(quit()));
	dlgBtnBox->addButton(exitButton, QDialogButtonBox::ActionRole);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);

//	this->setFocus ();
//	label->setFocus ();
//	this->focusNextChild();

}

LoginDialog::~LoginDialog()
{
}
void LoginDialog::about()
{
    QMessageBox::about(this, "About qtWallet", TEXT_ABOUT);
}
void LoginDialog::clearS()
{
	label->selectAll();
	label->del();
}

void LoginDialog::acceptS() {
	QString current = label->text();

	if (current.length() == 0) {
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", "Password is required", QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;

		return;
	}

	if (isFirstTime) {
		if (NTimes == 0) {
			newPassword = current;
			NTimes = 1;

			clearS ();

			if (messageBox.isNull()) {
				messageBox = new QMessageBox(this);
				messageBox->information(this, "Wallet", "For verification, please, enter your password again", QMessageBox::Ok);
			}
			delete messageBox;
			messageBox = 0;

			return;
		}
		if (NTimes == 1) {
			if (newPassword != current) {
				NTimes = 0;
				clearS ();
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet", "Invalid password, please enter again", QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;

				return;
			}
		}
	}

	if (parent->openDataBase (current)) {
		//close();
	}
	else {
		clearS ();
	}
}

void LoginDialog::select(const QString& a) {
	if (label->text().size() < KEY_SIZE) {
		QString current = label->text() + a;
		label->setText (current); //QString ("************************").right(current.size()));
	}
}

void LoginDialog::keyPressEvent(QKeyEvent* event) {
	if (event->key() == Qt::Key_Return || event->key() == Qt::Key_Enter) {
		event->accept();
		acceptS();
	}
}

void LoginDialog::resetF () {
	isFirstTime = true;
	NTimes = 0;
}
