/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef DETAIL_H
#define DETAIL_H

#include <QtGui>
#include <QDebug>
#include "DatabaseManager.h"

class eWallet;
class DetailWindow;

class CreateFieldDialog: public QDialog
{
	Q_OBJECT

public:
	CreateFieldDialog(Target * target, DetailWindow *paTarget );
	~CreateFieldDialog();

public slots:
	void previous();
	void next();
	void addNew();
	void save();
	void deleteCurrent();

private:
	void showField();
	void update();

	int pos;
	Target * target;
	DetailWindow * parent;
	QLineEdit * nameLineEdit;
	QLineEdit * orderEdit;
	QComboBox * typeLineEdit;
	QPushButton * previousButton;
	QPushButton * nextButton;
	QPushButton * deleteButton;
};


class DetailWindow: public QMainWindow
{
	Q_OBJECT

public:
	DetailWindow (Target * target, bool edit, eWallet *paTarget, QWidget *parent = 0);
	~DetailWindow ();
	
	void addField (TargetField * field);

private:
	int pos;
	eWallet * parent;
	
	QLabel * imageLabel;
	QLabel * imageBackLabel;
	Target * target;
	QWidget * centralWidget;
	QVBoxLayout * vboxlayout;
	QScrollArea * entryScrollArea;

	QLineEdit * nameLineEdit;
	QComboBox * typeLineEdit;
	QList<QLineEdit*> labels;
	QList<QWidget*> values;

	QPointer <QMessageBox> messageBox;

	QImage * currentImage;
	QImage * currentImageBack;
	QImage * currentImageN;
	QImage * currentImageBackN;

	QString orgType;

	void loadImage (QString q, QImage& res);
	void showFields ();
	void changeFields (int);
	void _addField (TargetField * field);

	bool edit;
	bool deleteFace;
	bool deleteBack;
	bool isNew;

	QGridLayout * componentLayout;
	QPointer<CreateFieldDialog> createFieldDlg;

public slots:
	void saveTarget();
	void _deleteTarget();
	void _editTarget();
	void _newTarget();
	void cardFace();
	void mirrorFace();
	void cardMenu(const QPoint & pos);
	void deleteCardFace();
	void exportCardFace();
	void cardFaceMenu(const QPoint & pos);
	void cardBack();	
	void mirrorBack();
	void deleteCardBack();
	void exportCardBack();
	void cardBackMenu(const QPoint & pos);
	void emitCommitData (int);
	void clickPass (QWidget *);
	void modifyFields ();

signals:
	void newTarget();
	void editTarget(Target * source);

};

class ButtonInfo: public QObjectUserData {
public:
	TargetField * field;

	ButtonInfo (TargetField * field) {
		this->field = field;
	}
};

#endif // DETAIL_H
