/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef EWALLET_H
#define EWALLET_H

#include <QtGui>
#include <QDebug>

#include "DatabaseManager.h"
#include "QFNListWidget.h"
#include "CreateTargetDialog.h"
#include "DetailedWindow.h"
#include "LoginDialog.h"

extern DatabaseManager * dbManager;

//class AboutDialog: public QMainWindow
//{
//	Q_OBJECT
//
//public:
//	AboutDialog(QWidget * paTarget);
//	~AboutDialog();
//private slots:
//	void donate ();
//};

class eWallet: public QMainWindow
{
	Q_OBJECT

public:
	eWallet (QWidget *parent = 0);
	~eWallet ();

	bool openDataBase (QString pas);
	bool _deleteTarget(Target* target);
	bool _updateTarget(Target* target);
	bool _updateTargetPicture(Target* target);
	bool _updateTargetPictureBack(Target* target);
	bool _insertTarget(Target* target);
	
	QList<QString> types;
	QList<QList<TargetField>*> fieldsByType;

public slots:
	void newTarget();
	void editTarget(Target * t);
	void deleteTarget(Target * t);
	void viewTarget(Target * t);
	Q_SCRIPTABLE void listenInactivity(QString s);

private:
	void showList ();
	void keyPressEvent(QKeyEvent*);
	void timerEvent(QTimerEvent*);
	void createMenu();
	void showTargets(bool reset);
	void loadTypesAndFields ();
	void filterBy (const QString & s);
	//void contextMenuEvent (QContextMenuEvent * event);

private slots:
    void windowDestroyed(QObject* obj = 0);
    void sort ();
	void _editcTarget();
	void _deletecTarget();
	void _viewcTarget();
	void lockWallet ();
	void _cancelSearch ();
	void _hideSearch ();
	void about ();
	void import();
	void exportData();
	void textChanged (const QString &);
	
private:
	//void timerEvent(QTimerEvent *event);
	void askPassword ();
	void closeEvent(QCloseEvent *event);
	
	QVBoxLayout * vboxlayout;
	int times;
	QFNListWidget* fnListWidget;
	QList<Target *> list;

	QHBoxLayout * inputWidget;
	QPushButton * cancelSearch;
	QPushButton * hideSearch;
	QLineEdit * searchField;

	QPointer<CreateTargetDialog> createTargetDlg;
	QPointer<LoginDialog> loginDialogDlg;
//	QPointer<AboutDialog> aboutDialogDlg;
	QPointer<DetailWindow> detailWindow;
	QPointer<DetailWindow> detailWindowEdit;
	QWidget* centralWidget;
	QPointer <QMessageBox> messageBox;
	bool opendb;
	bool initdb;
	bool ascSort;
	int row;
	Target * currentTarget;
	QString currentFilter;
	QTimer *timer;
};


#endif // EWALLET_H
