import Qt 4.7
import "content"

Rectangle {
	id: page
	width:  1000; height: 600
	color: "black"

	Row {
		id: searchBar
		y: 10
		width: parent.width - 20
		height: 40
		anchors.horizontalCenter: parent.horizontalCenter
		spacing: 10

		SearchBox{
			id: searchBox
			height: parent.height
			width: parent.width - searchButton.width - 10
			anchors.verticalCenter: parent.verticalCenter

			onReturnPressed: {
				if (searchBox.text != '') {
					feedModel.newSearch(searchBox.text);
				}
			}
		}

		Item {
			id: searchButton

			height: parent.height
			width: searchButtonText.width + 30

			anchors.verticalCenter: parent.verticalCenter

			Rectangle {
				anchors.fill: parent
				radius: 5
				gradient: Gradient {
					GradientStop {
						position: 0
						color: "#d3d3d3"
					}

					GradientStop {
						position: 0.47
						color: "#ffffff"
					}

					GradientStop {
						position: 1
						color: "#808080"
					}
				}
			}

			Text {
				id: searchButtonText
				anchors.horizontalCenter: parent.horizontalCenter
				anchors.verticalCenter: parent.verticalCenter

				text: "Search"
				smooth: true
				font.bold: true
				font.pixelSize: 20
			}

			MouseArea {
				anchors.fill: parent
				onClicked: {
					if (searchBox.text != '') {
						feedModel.newSearch(searchBox.text);
					}
				}
			}
		}
	}

	ListView {
		id: listView
		width: parent.width
		anchors.top: searchBar.bottom; anchors.topMargin: 10
		anchors.bottom: parent.bottom

		spacing: 5

		model: SeriesModel {
			id: feedModel;
			source: ''
			onStatusChanged: {
				if (status == XmlListModel.Loading){
					progresDialog.text = "Searching '" + searchBox.text + "'";
					progresDialog.value = 0.0;
					page.state = 'Searching';
				} else {
					page.state = '';
				}
			}
		}
		delegate: SeriesDelegate {
			onClicked:  {
				serieDelegate.loadDetails(seriesid, name, overview, banner);
				page.state = 'Serie';
			}
		}
	}

	SerieDelegate {
		id: serieDelegate
		visible: false
	}

	ProgresDialog {
		id: progresDialog;
		visible: false;
		anchors {horizontalCenter: parent.horizontalCenter; verticalCenter: parent.verticalCenter}
		value: feedModel.progress
	}

	states: [
		State {
			name: "Serie"
			PropertyChanges {
				target: serieDelegate
				visible: true
			}

			PropertyChanges {
				target: listView
				visible: false
			}
		},
		State {
			name: "Searching"
			PropertyChanges {
				target: progresDialog
				visible: true
			}
		}

	]

	transitions: [
		Transition {
			PropertyAnimation { properties: "opacity"; duration: 300}
		}
	]
}
