import Qt 4.7

Item {
	id: serie

	anchors.fill: parent

	property string name: ''
	property string overview: ''
	property string banner: ''
	property string seriesid: ''
	property int rating: -1

	function loadDetails(seriesid, name, overview, banner) {
		serie.seriesid = seriesid
		serie.name = name
		serie.overview = overview
		serie.banner = banner
		rating = -1

		serieModel.load(seriesid)
	}

	XmlListModel {
		id: serieModel

		function load(seriesId) {
			console.log("Loading " + seriesId)
			source = "http://thetvdb.com/api/040BCD04E3D1E109/series/" + seriesId + "/all/en.xml"
			reload();
		}

		source: ''
		query: "/Data/Series"

		XmlRole { name: "seriesid"; query: "id/string()" }

		XmlRole { name: "title"; query: "SeriesName/string()" }

		XmlRole { name: "banner"; query: "banner/string()" }
		XmlRole { name: "fanart"; query: "fanart/string()" }
		XmlRole { name: "poster"; query: "poster/string()" }

		XmlRole { name: "status"; query: "Status/string()" }
		XmlRole { name: "runtime"; query: "Runtime/string()" }
		XmlRole { name: "rating"; query: "Rating/string()" }
		XmlRole { name: "network"; query: "Network/string()" }
		XmlRole { name: "firstaired"; query: "FirstAired/string()" }

		onStatusChanged: {
			if (status == XmlListModel.Ready) {

				console.log("Serie detailes loaded");
				rating = get(0).rating;
				console.log("Rating: " + rating);

			} else if (status == XmlListModel.Error) {
				console.log("Error: " + errorString);
			}
		}
	}



	MouseArea {
		anchors.fill: parent
		onClicked: {
			serie.parent.state = ''
		}
	}

	Rectangle {
		id: background
		anchors.fill: parent
		color: "black"
	}

	Item {
		id: bannerLayout
		anchors.top: parent.top
		width: parent.width
		height: bannerText.height

		Image {
			id: bannerImg
			smooth: true
			anchors.top: parent.top
			anchors.horizontalCenter: parent.horizontalCenter
			width: parent.width * 0.6
			height: width * 0.1847
			fillMode: Image.PreserveAspectFit
			opacity: 0
			source: "http://thetvdb.com/banners/_cache/" + serie.banner
		}

		Text {
			id: bannerText
			anchors.top: parent.top
			anchors.horizontalCenter: parent.horizontalCenter
			text: serie.name

			color: "white"

			font.pointSize: 22
			font.bold: true

			opacity: 1
		}

		states: State {
			name: "loaded"
			when: bannerImg.status == Image.Ready
			PropertyChanges {
				target: bannerText
				opacity: 0
			}
			PropertyChanges {
				target: bannerImg
				opacity: 1
			}
			PropertyChanges {
				target: bannerLayout
				height: bannerImg.height
			}
		}

		transitions: Transition {
			PropertyAnimation { properties: "opacity, height"; duration: 300}
		}
	}

	Item {
		id: ratingBar
		width: parent.width - 20
		height: ratingRow.height
		anchors { top: bannerLayout.bottom; topMargin: 10; }
		anchors.horizontalCenter: parent.horizontalCenter

		opacity: 0.0

		Row {
			id: ratingRow
			width: parent.width
			height: 20
			spacing: 5
			Text {
				height: parent.height
				anchors.verticalCenter: parent.verticalCenter
				text: "Rating:  "
				color: "white"
				font.pixelSize: 20
				font.bold: true
			}

			Repeater {
				id: star_on
				model: rating

				Image {
					width: 20
					height: 20

					anchors.verticalCenter: parent.verticalCenter

					source: "pics/star_on.gif"
				}
			}

			Repeater {
				id: star_off
				model: 10 - rating

				Image {
					width: 20
					height: 20

					anchors.verticalCenter: parent.verticalCenter

					source: "pics/star_off.gif"
				}
			}
		}
		states: State {
			when: rating >= 0
			PropertyChanges {
				target: ratingBar
				opacity: 1.0
			}
		}

		Behavior on opacity {PropertyAnimation{duration: 300}}
	}

	Item {
		id: details
		width: parent.width - 20
		anchors { top: ratingBar.bottom; topMargin: 10; bottom: parent.bottom; bottomMargin: 10 }
		anchors.horizontalCenter: parent.horizontalCenter

		Text {
			id: overviewTitle
			anchors.top: banner.bottom
			text: "Overview"
			color: "white"
			font.pixelSize: 20
			font.bold: true
		}

		Flickable {
			id: flick
			width: parent.width
			anchors { top: overviewTitle.bottom; bottom: parent.bottom }
			contentHeight: overviewTitle.height
			clip: true

			Text { id: methodText; color: "white"; text: serie.overview; wrapMode: Text.WordWrap; width: details.width }

		}

		Image {
			anchors { right: flick.right; top: flick.top }
			source: "pics/moreUpW.png"
			opacity: flick.atYBeginning ? 0 : 1
		}

		Image {
			anchors { right: flick.right; bottom: flick.bottom }
			source: "pics/moreDownW.png"
			opacity: flick.atYEnd ? 0 : 1
		}
	}

	ProgresBar {
		id: progresBar
		visible: bannerImg.status == Image.Loading ? true : false
		width: parent.width * 0.3; height: 10
		anchors {bottom: parent.bottom; right: parent.right}

		value: bannerImg.progress
	}
}
