import Qt 4.7

FocusScope {
	id: focusScope
	width: 250; height: textInput.height + 10

	property string text: textInput.text

	signal returnPressed();

	Rectangle {
		anchors.fill: parent
		color: "white"
		border.color: parent.activeFocus ? "lightsteelblue" : "gray"
		border.width: 2
		radius: 5
	}

	Text {
		id: typeSomething
		verticalAlignment: Text.AlignVCenter
		text: "Type show name"
		anchors.right: parent.right
		anchors.rightMargin: 8
		anchors.left: parent.left
		anchors.leftMargin: 8
		anchors.verticalCenter: parent.verticalCenter
		smooth: true
		color: "gray"
		font.italic: true
		font.pixelSize: 20
	}

	MouseArea {
		anchors.fill: parent
		onClicked: { focusScope.focus = true; textInput.openSoftwareInputPanel(); }
	}

	TextInput {
		id: textInput
		smooth: true
		anchors { left: parent.left; leftMargin: 8; right: clear.left; rightMargin: 8; verticalCenter: parent.verticalCenter }
		focus: true
		selectByMouse: true

		font.bold: true
		font.pixelSize: 20

		Keys.onReturnPressed: returnPressed()
	}

	Image {
		id: clear
		height: parent.height
		width: height
		smooth: true
		fillMode: Image.PreserveAspectFit
		anchors { right: parent.right; rightMargin: 8; verticalCenter: parent.verticalCenter }
		source: "pics/clear.png"
		opacity: 0

		MouseArea {
			anchors.fill: parent
			onClicked: { textInput.text = ''; focusScope.focus = true; textInput.openSoftwareInputPanel(); }
		}
	}

	states: State {
		name: "hasText"; when: textInput.text != ''
		PropertyChanges { target: typeSomething; opacity: 0 }
		PropertyChanges { target: clear; opacity: 1 }
	}

	transitions: [
		Transition {
			from: ""; to: "hasText"
			NumberAnimation { exclude: typeSomething; properties: "opacity" }
		},
		Transition {
			from: "hasText"; to: ""
			NumberAnimation { properties: "opacity" }
		}
	]
}
