#ifndef _QTRAPIDS_INFO_HPP_
#define _QTRAPIDS_INFO_HPP_

#include <libtorrent/torrent_handle.hpp>

//#include <limits>
//#include <stdint.h>

#include <QString>

namespace qtrapids
{

static const uint32_t torrent_progress_max = 1000000;
static const uint32_t torrent_progress_percent = 10000;
//std::numeric_limits<uint32_t>::max();

typedef libtorrent::torrent_status TorrentStatus_t;
typedef libtorrent::torrent_status::state_t TorrentStatusIds_t;

struct TorrentStatus {
	enum Id {
		QUEUED_FOR_CHECKING = TorrentStatus_t::queued_for_checking,
		CHECKING_FILES = TorrentStatus_t::checking_files,
		DOWNLOADING_METADATA = TorrentStatus_t::downloading_metadata,
		DOWNLOADING = TorrentStatus_t::downloading,
		FINISHED = TorrentStatus_t::finished,
		SEEDING = TorrentStatus_t::seeding,
		ALLOCATING = TorrentStatus_t::allocating,
		CHECKING_RESUME_DATA = TorrentStatus_t::checking_resume_data,
		UNSPECIFIED
	};
};

struct TorrentDownloadInfo {
	QString hash;
	QString path;
	QString download_path;
};


} // namespace qtrapids

#endif // _QTRAPIDS_INFO_HPP_

