/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QDebug>

#include "QTorrentHandle.h"

namespace qtrapids
{


QTorrentHandle::QTorrentHandle(libtorrent::torrent_handle handle) :
		torrentHandle_(handle)
{
}


QTorrentHandle::~QTorrentHandle()
{
}


TorrentStatus QTorrentHandle::status() const
{
	return torrentHandle_.status();
}


TorrentInfo const& QTorrentHandle::getTorrentInfo() const
{
	return torrentHandle_.get_torrent_info();
}


bool QTorrentHandle::isValid() const
{
	return torrentHandle_.is_valid();
}


QString QTorrentHandle::name() const
{
	return QString::fromStdString(torrentHandle_.name());
}

size_t QTorrentHandle::getTotalSize() const
{
	TorrentInfo info = getTorrentInfo();
	return static_cast<size_t> (info.total_size());
}


QTorrentHandle::State QTorrentHandle::state() const
{
	TorrentStatus statusTmp = status();

	switch (statusTmp.state) {
	case TorrentStatus::queued_for_checking :
		return QTorrentHandle::QUEUED_FOR_CHECKING;
	case TorrentStatus::checking_files :
		return QTorrentHandle::CHECKING_FILES;
	case TorrentStatus::downloading_metadata :
		return QTorrentHandle::DOWNLOADING_METADATA;
	case TorrentStatus::downloading :
		return QTorrentHandle::DOWNLOADING;
	case TorrentStatus::finished :
		return QTorrentHandle::FINISHED;
	case TorrentStatus::seeding :
		return QTorrentHandle::SEEDING;
	case TorrentStatus::allocating :
		return QTorrentHandle::ALLOCATING;
	default:
		return QTorrentHandle::UNSPECIFIED;
	}

}


float QTorrentHandle::progress() const
{
	TorrentStatus statusTmp = status();
	return statusTmp.progress;
}

float QTorrentHandle::uploadRate() const
{
	TorrentStatus statusTmp = status();
	return statusTmp.upload_rate;
}


float QTorrentHandle::downloadRate() const
{
	TorrentStatus statusTmp = status();
	return statusTmp.download_rate;
}


qint32 QTorrentHandle::numSeeds() const
{
	TorrentStatus statusTmp = status();
	return statusTmp.list_seeds;
}


qint32 QTorrentHandle::numLeeches() const
{
	TorrentStatus statusTmp = status();
	return (statusTmp.list_peers - statusTmp.list_seeds);
}


qint32 QTorrentHandle::ratio() const
{
	TorrentStatus statusTmp = status();
	size_t ratio;
	if (statusTmp.total_payload_download == 0) {
		ratio = 0;
	} else {
		ratio = static_cast<size_t> (statusTmp.total_payload_upload / statusTmp.total_payload_download);
	}

	return ratio;
}


TorrentHandle QTorrentHandle::getHandle() const
{
	return torrentHandle_;
}


bool QTorrentHandle::operator==(QTorrentHandle const& h) const
{
	return torrentHandle_ == h.torrentHandle_;
}


bool QTorrentHandle::operator<(QTorrentHandle const& h) const
{
	return torrentHandle_ < h.torrentHandle_;
}

} // namespace qtrapids


