/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QBITTORRENTSESSION_H
#define QBITTORRENTSESSION_H

#include <memory>

#include <QObject>

#include <libtorrent/session.hpp>
#include <libtorrent/torrent_info.hpp>
#include <libtorrent/alert_types.hpp>

#include "QTorrentHandle.h"


// Forward declarations and typedefs
class AlertWaiterThread;
typedef libtorrent::session TorrentSession;
typedef libtorrent::session_settings SessionSettings;
typedef libtorrent::add_torrent_params AddTorrentParams;
typedef libtorrent::alert Alert;
typedef	libtorrent::torrent_alert TorrentAlert;
typedef libtorrent::sha1_hash Sha1Hash;


namespace qtrapids
{

/**
	@author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/
class QBittorrentSession : public QObject
{
	Q_OBJECT
//		class	BitTorrentSession;

public:
	QBittorrentSession(QObject *parent = 0);
	~QBittorrentSession();

	/// @brief Add torrent to session.
	qtrapids::QTorrentHandle addTorrent(AddTorrentParams const& params);
	void removeTorrent(qtrapids::QTorrentHandle const& handle);

	void setUploadRateLimit(int rate);
	void setDownloadRateLimit(int rate);
	int getUploadRateLimt() const;
	int getDownloadRateLimit() const;
	
signals:
	void alert(std::auto_ptr<Alert> al);

private slots:
	void on_alert(Alert const *al);

private:
	TorrentSession btSession_;
	AlertWaiterThread *alertWaiter_;

};

} //namespace qtrapids
#endif
