/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QDebug>

#include "AlertWaiterThread.h"
#include "QBittorrentSession.h"

namespace qtrapids
{

QBittorrentSession::QBittorrentSession(QObject *parent):
		QObject(parent),
		btSession_(),
		alertWaiter_(NULL)
{
	alertWaiter_ = new AlertWaiterThread(&btSession_, this);
	alertWaiter_->allAlerts();
	connect(alertWaiter_, SIGNAL(alert(Alert const*)), this, SLOT(on_alert(Alert const*)));
	alertWaiter_->start();
	
	SessionSettings settings;
	settings.ignore_limits_on_local_network = false;
	btSession_.set_settings(settings);
	
}


QBittorrentSession::~QBittorrentSession()
{
}


qtrapids::QTorrentHandle
QBittorrentSession::addTorrent(AddTorrentParams const& params)
{
	// Delegate to Libtorrent and return QTorrentHandle.
	//std::auto_ptr<QTorrentHandle> handlePtr(new QTorrentHandle(btSession_.add_torrent(params)));
	qtrapids::QTorrentHandle  handle = qtrapids::QTorrentHandle(btSession_.add_torrent(params));
	return handle;
}


void QBittorrentSession::removeTorrent(qtrapids::QTorrentHandle const& handle)
{
	btSession_.remove_torrent(handle.getHandle());
}


void QBittorrentSession::setUploadRateLimit(int rate)
{
	btSession_.set_upload_rate_limit(rate);
}


void QBittorrentSession::setDownloadRateLimit(int rate)
{
	btSession_.set_download_rate_limit(rate);
}


int QBittorrentSession::getUploadRateLimt() const
{
	return btSession_.upload_rate_limit();
}


int QBittorrentSession::getDownloadRateLimit() const
{
	return btSession_.download_rate_limit();
}





// ========================== SLOTS ==============================
/// @TODO This function is called when AlertWaiterThread emits alert()
/// If connection is direct, as it is now, we need to use QMutex here (if necessary?)
void QBittorrentSession::on_alert(Alert const *al)
//NOTE: al parameter not necessarily needed here, as we pop_alert() now!
{

#ifdef QTRAPIDS_DEBUG
	//if (al)
	//	qDebug() << "on_alert():" << QString::fromStdString(al->message());
#endif

	std::auto_ptr<Alert> alertPtr = btSession_.pop_alert();
	emit alert(alertPtr);
}

} //namespace qtrapids
