/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <QDebug>

#include "AlertWaiterThread.h"

// Constants:
// Timeout for waiting alerts
const libtorrent::time_duration ALERT_WAIT_TIMEOUT
= libtorrent::time_duration(libtorrent::seconds(15));


AlertWaiterThread::AlertWaiterThread(TorrentSession *const session, QObject* parent) :
		QThread(parent),
		btSession_(session)
{
}


AlertWaiterThread::~AlertWaiterThread()
{
}


void AlertWaiterThread::allAlerts(bool enable)
{
	// If all enabled, set all alert cateogries:
	if (enable) {
		btSession_->set_alert_mask(libtorrent::alert::all_categories);
	} else {
		// Otherwise set to default, which is only error notifications.
		btSession_->set_alert_mask(libtorrent::alert::error_notification);
	}
}


void AlertWaiterThread::run()
{
	Alert const *alertTemp = NULL;
	while (true) {
#ifdef QTRAPIDS_DEBUG
		qDebug() << "AlertWaiter running";
#endif
		// wait_for_alert() call blocks. Returns libtorrent alert.
		// Returns NULL, if no alerts in timeout period.
		alertTemp = btSession_->wait_for_alert(ALERT_WAIT_TIMEOUT);
		emit alert(alertTemp);
		// 2000 us = 2ms. Gives main thread time to handle alert signal.
		usleep(2000);
	}
}
