/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include <QDialog>
#include <QSettings>


class QAbstractButton;
class QLineEdit;
class QSpinBox;
class QDialogButtonBox;

class QtRapidsServer;


/**
	@author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/
class PreferencesDialog : public QDialog
{

	Q_OBJECT

public:
	PreferencesDialog(QWidget* parent = 0, Qt::WindowFlags f = 0, QtRapidsServer *server = 0);

	~PreferencesDialog();

private slots:
	void on_browseDirButtonClicked();
	void on_buttonClicked(QAbstractButton* button);
	void on_downloadDirectorySelected(QString directory);

private:
	QLineEdit *dirLineEdit_;
	QDialogButtonBox *dialogButtons_;
	QSpinBox *uploadRateSpinBox_, *downloadRateSpinBox_;
	
	QtRapidsServer *server_;

	QSettings settings_;

private:
	// Private functions:
	void WriteSettings();
	void ReadSettings();
};

#endif
