/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QTORRENTHANDLE_H
#define QTORRENTHANDLE_H

#include <QtGlobal>
#include <QString>

#include <qtrapids/info.hpp>
#include <libtorrent/torrent_handle.hpp>

namespace qtrapids
{

typedef libtorrent::torrent_info const& torrent_info_cref;
typedef libtorrent::torrent_handle torrent_handle_t;
typedef libtorrent::sha1_hash Sha1Hash;


inline QString Hash2QStr(Sha1Hash const& hash)
{
	return QString(hash.to_string().c_str());
}

/**
   @author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/
class TorrentHandle
{
public:

	TorrentHandle(libtorrent::torrent_handle handle);
	~TorrentHandle();



	torrent_info_cref getTorrentInfo() const;

	bool isValid() const;

	Sha1Hash hash() const {
		return torrentHandle_.info_hash();
	}

	QString name() const;
	size_t getTotalSize() const;
	size_t getTotalDone() const;
	TorrentStatus::Id state() const;
	float progress() const;
	float uploadRate() const;
	float downloadRate() const;
	qint32 numSeeds() const;
	qint32 numLeeches() const;
	qint32 ratio() const;

	torrent_handle_t getHandle() const;
	bool operator==(TorrentHandle const& h) const;
	bool operator<(TorrentHandle const& h) const;

private:
	TorrentHandle(); // Prevent default construct.
	torrent_handle_t torrentHandle_;

	TorrentStatus_t status() const;

};

}

#endif
