#ifndef _QTRAPIDS_FORMAT_HPP_
#define _QTRAPIDS_FORMAT_HPP_

#include <qtrapids/info.hpp>
#include <QtCore/QString>

#include <QDebug>

namespace qtrapids
{


static inline QString formatProgress(uint progress)
{
	return QString::number(progress / torrent_progress_percent);
}

namespace {

static const qulonglong size_KB = 1024;
static const qulonglong size_MB = size_KB << 10;
static const qulonglong size_GB = size_MB << 10;

static char const* size_names[] = {
	"GB",
	"MB",
	"KB",
	"B"
};

const qulonglong SECONDS_IN_DAY = 60*60*24;
}

static inline QString formatSize(qulonglong size)
{
	qulonglong unit = size_GB;
	char const ** unit_name = &size_names[0];
	QString ret("");
	for (unit = size_GB; unit > 0; unit >>= 10, ++unit_name) {
		if (size & (~(unit - 1))) {
			ret += (QString::number(size / unit) + *unit_name);
			return ret;
		}
	}
	ret = QString::number(size) + "B";
	return ret;
}


inline QString formatElapsedTime(qulonglong seconds)
{
	qulonglong hours = 0, minutes = 0, secsLeft = 0;
	QString dayStr, hourStr, minStr, secStr;
	dayStr = hourStr = minStr = secStr = QString::number(0);
	
	//result.reserve(8);
	
	hours = seconds / 3600;
	secsLeft = seconds % 3600;
	minutes = secsLeft / 60;
	secsLeft = secsLeft % 60;

	// If more than 24 hours, format time as days, hours.
	// Otherwise hours : mins : secs
	if (hours >= 24) {
		dayStr = QString::number(hours / 24);
		hourStr = QString::number(hours % 24);
		return dayStr + 'd' + ' ' + hourStr + 'h';
	} else if (hours < 10) {
		hourStr.append(QString::number(hours));
	} else {
		hourStr = QString::number(hours);
	}
	
	if (minutes < 10) {
		minStr.append(QString::number(minutes));
	} else {
		minStr = QString::number(minutes);
	}
	
	if (secsLeft < 10) {
		secStr.append(QString::number(secsLeft));
	} else {
		secStr = QString::number(secsLeft);
	}
		
	return hourStr + ':' + minStr + ':' + secStr;
}

} // namespace qtrapids

#endif // _QTRAPIDS_FORMAT_HPP_

