#ifndef _QTRAPIDS_DBUS_HPP_
#define _QTRAPIDS_DBUS_HPP_

#include <QtDBus/QtDBus>
#include <QtCore/QString>
#include <QtCore/QHash>

// TMP TODO
#include <iostream>

namespace qtrapids
{

struct TorrentState {

	enum torrent_action {
		action_add,
		action_remove,
		action_update
	};

	TorrentState()
			: hash("")
			, name("")
			, state(0)
			, progress(0)
			, down_rate(0)
			, up_rate(0)
			, seeds(0)
			, leeches(0)
			, ratio(0)
			, total_size(0)
			, total_done(0){ }

	QString hash;
	QString name;
	torrent_action action;
	uint state;
	uint progress;
	uint down_rate;
	uint up_rate;
	uint seeds;
	uint leeches;
	uint ratio;
	qulonglong total_size;
	qulonglong total_done;
};

typedef QHash<QString, QString> ParamsMap_t;
typedef QHash<QString, QString> const ParamsMapConst_t;
typedef ParamsMap_t::iterator ParamsMapIterator_t;
typedef ParamsMap_t::const_iterator ParamsMapConstIterator_t;

static inline QDBusArgument& operator << (QDBusArgument& argument
        , TorrentState const& state)
{
#ifdef QTRAPIDS_DEBUG
	std::cout << "serialize" << std::endl;
#endif
	argument.beginStructure();
	argument << state.hash << state.name << (uint)(state.action) << state.state << state.progress
	<< state.down_rate << state.up_rate << state.seeds
	<< state.leeches << state.ratio << state.total_size << state.total_done;
	argument.endStructure();
	return argument;
}

static inline QDBusArgument const& operator >> (QDBusArgument const& argument
        , TorrentState& state)
{
#ifdef QTRAPIDS_DEBUG
	std::cout << "deserialize" << std::endl;
#endif
	argument.beginStructure();
	uint action;
	argument >> state.hash >> state.name >> action >> state.state >> state.progress
	>> state.down_rate >> state.up_rate >> state.seeds
	>> state.leeches >> state.ratio >> state.total_size >> state.total_done;
	state.action = (TorrentState::torrent_action)action;
	argument.endStructure();
	return argument;
}

static inline QDBusArgument& operator << (QDBusArgument& argument
        , ParamsMapConst_t& params)
{
	ParamsMapConstIterator_t p;
#ifdef QTRAPIDS_DEBUG
	std::cout << "serialize params" << std::endl;
#endif

	argument.beginMap();
	for (p = params.constBegin(); p != params.constEnd(); ++p) {
		argument.beginMapEntry();
		argument << p.key() << p.value();
		argument.endMapEntry();
	}
	argument.endMap();
	return argument;
}

static inline QDBusArgument const& operator >> (QDBusArgument const& argument
        , ParamsMap_t& params)
{
	ParamsMapConstIterator_t p;
	QString key, value;
#ifdef QTRAPIDS_DEBUG
	std::cout << "deserialize params" << std::endl;
#endif
	argument.beginMap();
	for (p = params.constBegin(); p != params.constEnd(); ++p) {
		argument.beginMapEntry();
		argument >> key >> value;
		params[key] = value;
		argument.endMapEntry();
	}
	argument.endMap();
	return argument;
}


// class DBusConnector
// {
// public:
//     DBusConnector()
//         : connection_()
//     {
//     }
// private:
//     QDBusConnection connection_;
// };

}

Q_DECLARE_METATYPE(qtrapids::TorrentState);
Q_DECLARE_METATYPE(qtrapids::ParamsMap_t);

#endif // _QTRAPIDS_DBUS_HPP_

