#include "mainwindow.h"
#include "ui_mainwindow.h"


//using namespace std;

PianobarQt::PianobarQt(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::PianobarQtClass) {
    ui->setupUi(this);

    //////// connect signals

    connect(&process, SIGNAL(readyReadStandardOutput()), this, SLOT(on_cmdExec_data_available()));
    //    connect(&process, SIGNAL(finished(int)), this, SLOT(on_cmdExec_finish()));
    connect(ui->comboBox_stations,SIGNAL(currentIndexChanged(QString)),this,SLOT(comboxBox_stations_currentIndexChanged(QString)));
    connect(ui->actionUsernamePassword,SIGNAL(triggered()),this,SLOT(set_usernamePassword()));
    connect(ui->webView,SIGNAL(loadFinished(bool)),this,SLOT(on_webView_loadFinished()));
    ////////////////////////

    playing = false;
    paused = false;
    stationChanged = false;
    stationsPopulated = false;

    play = QIcon(":/images/images/playing.png");
    skipping = QIcon(":/images/images/skip-active.png");
    skip = QIcon(":/images/images/skip.png");
    pause = QIcon(":/images/images/paused.png");
    ban = QIcon(":/images/images/minus.png");
    banning = QIcon(":/images/images/minus-active.png");

    fav = QIcon(":/images/images/plus.png");
    favour = QIcon(":/images/images/plus-active.png");

    QFile configFile("/home/user/.config/pianobar/config");
    if(!configFile.exists()) {
        QErrorMessage *noConfig = new QErrorMessage(this);
        noConfig->setWindowTitle(tr("No Config File"));
        noConfig->showMessage(tr("Config file missing. Please choose Username/Password from menu"));
    }

    QString cmd = "/usr/bin/pianobar";
    process.start(cmd);

    stripSong.setPattern(".*>\\s+\".*\" by");
    stripNext.setPattern(".*0.*\" by");
    stripAscii.setPattern("[-,/,),(,),&,',:]");

    songFavoured.setPattern(".* <3");
    //    rxlen.setPattern("Ok.*0.*");
    rxlen.setPattern("Ok.*\\s+\\d+");
    stripTimeLeft.setPattern("#\\s+-\\d+.*/\\d+");

}

PianobarQt::~PianobarQt() {
    delete ui;
}

void PianobarQt::on_pushButton_next_clicked() {
    ui->output->clear();
    ui->output->setText("Song Skipped");
    process.write("n\n");
    if(paused) {
        process.write("p\n");
    }
}

void PianobarQt::on_pushButton_next_pressed() {
    ui->pushButton_next->setIcon(skipping);
}

void PianobarQt::on_pushButton_next_released() {
    ui->pushButton_next->setIcon(skip);
}

void PianobarQt::on_pushButton_favourite_clicked() {
    process.write("+\n");
}

void PianobarQt::on_pushButton_favourite_pressed() {
    ui->pushButton_favourite->setIcon(favour);
}

void PianobarQt::on_pushButton_favourite_released() {
    //        ui->pushButton_favourite->setIcon(fav);
}

void PianobarQt::on_pushButton_ban_clicked() {
    process.write("-\n");     
}

void PianobarQt::on_pushButton_ban_released() {
    ui->pushButton_ban->setIcon(ban);
}

void PianobarQt::on_pushButton_ban_pressed() {
    ui->pushButton_ban->setIcon(banning);
}

void PianobarQt::on_pushButton_playpause_clicked() {
    if(playing) {
        ui->pushButton_playpause->setIcon(pause);
        playing = false;
        paused = true;
    } else
    {
        ui->pushButton_playpause->setIcon(play);
        playing = true;
        paused = false;
    }
    process.write("p\n");
}


void PianobarQt::set_usernamePassword() {


    input = new QDialog(this,Qt::Dialog);
    input->setWindowTitle(tr("Input Username/Password"));

    QFormLayout *layout = new QFormLayout();

    username = new QLineEdit();

    password = new QLineEdit();
    password->setEchoMode(QLineEdit::PasswordEchoOnEdit);

    QPushButton *ok = new QPushButton;
    ok->setText(tr("Save"));

    connect(ok,SIGNAL(clicked()),this,SLOT(save_Username_password()));

    layout->addRow(new QLabel(tr("Username")),username);
    layout->addRow(new QLabel(tr("Password")),password);
    layout->addRow(ok);

    input->setLayout(layout);

    QFile configFile("/home/user/.config/pianobar/config");

    if(configFile.exists()) {
        if (!configFile.open(QIODevice::ReadOnly)) {
            QErrorMessage *noConfig = new QErrorMessage(this);
            noConfig->setWindowTitle(tr("Cannot read/write config"));
            noConfig->showMessage(tr("Unable to read/write config file. Please check permissions"));
        }

        char buf[1024];

        while(configFile.readLine(buf,sizeof(buf)) != -1)  {
            QString line(buf);
            if(line.startsWith("#user") || line.startsWith(("user"))) {
                QStringList splitLine = line.split("=");
                username->setText(QString(splitLine.at(1)).trimmed());
            }
            else if(line.startsWith("#password") || line.startsWith(("password"))) {
                QStringList splitLine = line.split("=");
                password->setText(QString(splitLine.at(1)).trimmed());
            }
        }
    }

    configFile.close();

    input->show();
}

void PianobarQt::save_Username_password() {

    input->hide();

    QFile configFile("/home/user/.config/pianobar/config");
    QFile configFileTmp("/home/user/.config/pianobar/config-tmp");
    QDir configDir("/home/user/.config/pianobar");

    if(!configDir.exists()) {
        if(configDir.mkdir("/home/user/.config/pianobar")) {
            QErrorMessage *noConfig = new QErrorMessage(this);
            noConfig->setWindowTitle(tr("Cannot create config directory"));
            noConfig->setWindowFlags(Qt::Popup);
            noConfig->showMessage(tr("Unable to create config directory. Please check permissions"));
            return;
        }
    }
    if(!configFile.exists()) {
        if (!configFile.open(QIODevice::WriteOnly)) {
            QErrorMessage *noConfig = new QErrorMessage(this);
            noConfig->setWindowTitle(tr("Cannot write config"));
            noConfig->showMessage(tr("Unable to write config file. Please check permissions"));
        } else {
            configFile.write("# This is an example configuration file for pianobar. You may remove the\n");
            configFile.write("# from lines you need and copy/move this file to ~/.config/pianobar/config\n");
            configFile.write("# See manpage for a description of the config keys\n");
            configFile.write("#\n");
            configFile.write("# User\n");
            configFile.write("user = "+username->text().toLatin1()+"\n");
            configFile.write("password = "+password->text().toLatin1()+"\n\n");
            configFile.write("# last.fm scrobbling\n");
            configFile.write("#lastfm_user = username\n");
            configFile.write("#lastfm_password = password\n");
            configFile.write("#lastfm_scrobble_percent = 50\n\n");
            configFile.write("# Proxy (for those who are not living in the USA)\n");
            configFile.write("#control_proxy = http://127.0.0.1:9090/\n\n");
            configFile.write("# Keybindings\n");
            configFile.write("#act_help = ?\n");
            configFile.write("#act_songlove = +\n");
            configFile.write("#act_songban = -\n");
            configFile.write("#act_stationaddmusic = a\n");
            configFile.write("#act_stationcreate = c\n");
            configFile.write("#act_stationdelete = d\n");
            configFile.write("#act_songexplain = e\n");
            configFile.write("#act_stationaddbygenre = g\n");
            configFile.write("#act_songinfo = i\n");
            configFile.write("#act_addshared = j\n");
            configFile.write("#act_songmove = m\n");
            configFile.write("#act_songnext = n\n");
            configFile.write("#act_songpause = p\n");
            configFile.write("#act_quit = q\n");
            configFile.write("#act_stationrename = r\n");
            configFile.write("#act_stationchange = s\n");
            configFile.write("#act_songtired = t\n");
            configFile.write("#act_upcoming = u\n");
            configFile.write("#act_stationselectquickmix = x\n\n");
            configFile.write("# Misc\n");
            configFile.write("# mp3 or aacplus\n");
            configFile.write("#audio_format = mp3\n");
            configFile.write("#autostart_station = 123456\n");
            configFile.write("#event_command = /home/user/.config/pianobar/eventcmd\n");
            configFile.close();
            process.close();
            QString cmd = "/usr/bin/pianobar";
            process.start(cmd);
        }
    }
    else {
        if (!configFile.open(QIODevice::ReadOnly) || !configFileTmp.open(QIODevice::WriteOnly)) {
            QErrorMessage *noConfig = new QErrorMessage(this);
            noConfig->setWindowTitle(tr("Cannot read/write config"));
            noConfig->showMessage(tr("Unable to read/write config file. Please check permissions"));
        } else {
            char buf[1024];

            while(configFile.readLine(buf,sizeof(buf)) != -1)  {
                QString line(buf);
                if(line.startsWith("#user") || line.startsWith(("user"))) {
                    configFileTmp.write("user = "+username->text().toLatin1()+"\n");
                }
                else if(line.startsWith("#password") || line.startsWith(("password"))) {
                    configFileTmp.write("password = "+password->text().toLatin1()+"\n");
                }
                else {
                    configFileTmp.write(buf);
                }
            }
            configFile.remove();
            configFileTmp.copy(configFile.fileName());
            configFileTmp.remove();
            process.close();
            QString cmd = "/usr/bin/pianobar";
            process.start(cmd);
        }
    }
}

void PianobarQt::comboxBox_stations_currentIndexChanged(QString item) {

    if(ui->comboBox_stations->currentIndex() != 0)
        if(stationsPopulated) {

        selected = QByteArray(QString::number(ui->comboBox_stations->currentIndex() - 1).toLocal8Bit()+"\n");
        if(playing || paused) {
            //            ui->textEdit_output->append("Chose: "+item+" at "+QString::number(ui->comboBox_stations->currentIndex()));
            process.write("q\n");
            process.close();
            ui->lcdNumber_timeLeft->display(QString("00:00"));
            ui->lcdNumber_totalTime->display(QString("00:00"));
            QString cmd = "/usr/bin/pianobar";
            process.start(cmd);
            stationChanged = true;
        } else {
            process.write(selected);
            ui->pushButton_playpause->setIcon(play);
            playing = true;
        }
        ui->pushButton_favourite->setDisabled(false);
        ui->pushButton_ban->setDisabled(false);
        ui->pushButton_next->setDisabled(false);
        //        ui->pushButton_quit->setDisabled(false);
        ui->pushButton_playpause->setDisabled(false);
    }

}
void PianobarQt::scroll_output () {

    if(nextSong.length() > ui->output->maxLength()) {
        while(message.length() < ui->output->maxLength()) {
            message += "    "+nextSong;
        }
        message.remove(0,1);
        ui->output->setText(message);

    } else  {
        timer->stop();
        //        string foo = string(nextSong.toLatin1());
        //        std::cout << "OUTPUT: " << foo << "\n" << nextSong.length() << " " << ui->output->maxLength();
    }

}

void PianobarQt::on_webView_loadFinished() {
    QWebFrame *frame = ui->webView->page()->mainFrame();
    QWebElementCollection elements = frame->findAllElements(QString("img"));
    if(elements.count() < 2) {
        ui->nocoverImage->setVisible(true);
    } else{
        QWebElement element = elements.at(1);

        QStringList imgList = element.toOuterXml().split("\"");
        QString image = imgList.at(1);

        QUrl imgUrl(image);        

        ui->webView->blockSignals(true);
        //        tmpView->blockSignals(true);
        ui->webView->load(imgUrl);
        ui->nocoverImage->setVisible(false);
        ui->webView->setVisible(true);
//                std::cout << "FUDGEIT" << string(image.toLatin1()) << "\n";
        //        foreach(QWebElement element,elements) {
        //
        //            std::cout << "FUDGEIT" << string(element.toOuterXml().toLatin1()) << "\n";
        //        }

        //            ui->webView->setUrl(url);
    }

}

void PianobarQt::on_cmdExec_data_available() {
    QByteArray stuff =  process.readAllStandardOutput();
    QString output(stuff);
    //    string foo = string(stuff);
    //    std::cout << "OUTPUT: " << foo << "\n";
    if(stationChanged) {
        ui->output->clear();
        ui->output->setText("Changing Station");
        process.write(selected);
        stationChanged = false;
        if(paused) {
            process.write("p\n");
        } else
            playing = true;
    }

    if(output.contains(stripSong)) {
        if(output.contains(songFavoured)) {
            ui->pushButton_favourite->setIcon(favour);
        } else
        {
            ui->pushButton_favourite->setIcon(fav);
        }
        ui->nocoverImage->setVisible(true);
        QStringList song = output.split(">");
        QStringList songComponents = QString(song.at(1)).split("\"");
        ui->label_songTitle->setText(QString(songComponents.at(1)));
        ui->label_artist->setText(QString(songComponents.at(3)));
        ui->label_album->setText(QString(songComponents.at(5)));
        process.write("u\n");

        QString artist(songComponents.at(3));
        QString album(songComponents.at(5));

        QUrl url("http://www.slothradio.com/covers/index.php?adv=1&artist="+artist.remove(stripAscii)+"&album="+album.remove(stripAscii)+"&imgsize=m");

//                std::cout << string(url.toString().toLatin1()) << "\n";

        ui->webView->blockSignals(false);
        ui->webView->load(url);

    }

    else if(output.contains(stripNext)) {

        QStringList nextSongs = output.split("\n");
        ui->output->setText(QString(nextSongs.at(0)).replace("0)","").trimmed());


        nextSong = QString(nextSongs.at(0)).replace("0)","").trimmed();
        //        nextSong = output.replace("0)","").trimmed();

        message = "";
        timer->start();

    }

    else if(output.startsWith("(i) No songs in queue")) {
        ui->output->setText("No songs in queue");
        nextSong = "";
        message = "";
    }

    if(output.contains(stripTimeLeft)) {
        QStringList timeLeft = output.split("/");
        ui->lcdNumber_timeLeft->display(QString(timeLeft.at(0)).remove("-"));
        ui->lcdNumber_totalTime->display(QString(timeLeft.at(1)));
    }

    //    Q_ASSERT(rxlen.isValid());

    if (output.contains(rxlen)) {
        stations = output.split("\n");

        if(!stationsPopulated) {
            for (int i = 0;i < stations.size()-1;i++) {
                QString station(stations.at(i+1));
                rxlen.setPattern(".*\\d+");
                if(station.contains(rxlen)) {
                    int start = station.indexOf(')',0,Qt::CaseInsensitive);
                    int end = station.length();
                    QString stationName = station.mid(start+4,end);
                    ui->comboBox_stations->addItem(stationName,QVariant(i+1));
                }
            }
            ui->comboBox_stations->setEnabled(true);
            stationsPopulated = true;
            timer = new QTimer(this);
            timer->setInterval(150);


            connect(timer,SIGNAL(timeout()),this,SLOT(scroll_output()));

        }
    }
}
