#ifndef MOBILEHOTSPOTGUI_H
#define MOBILEHOTSPOTGUI_H

#include <QtGui/QMainWindow>
#include <QtCore/QList>
#include <QtCore/QStringList>
#include <QtCore/QString>
#include <QtGui/QCloseEvent>
#include <QtCore/QProcess>
#include <QtCore/QMap>
#include <QtGui/QAction>
#include <QtDBus/QDBusMessage>
#include "dbushelper.h"
#include "mobilehotspotconfiguration.h"
#include "mobilehotspotplugin.h"
#include "ui_mobilehotspotgui.h"


class MobileHotspotGUI : public QMainWindow
{
    Q_OBJECT

public:
    MobileHotspotGUI(QWidget *parent = 0);
    ~MobileHotspotGUI();

private:
	void updateDisplayedConfiguration();
	void loadPlugins();
	void sortPlugins();
	void displayPlugins();
	void previousConnectionEnableSignal();
	void previousConnectionDisableSignal();
	void previousConnectionRequest();
	void availableAPNsEnableSignal();
	void availableAPNsDisableSignal();
	void availableAPNsRequest();

	Ui::MobileHotspotGUIClass ui;
    QMap<QString, MobileHotspotPlugin*> plugins;
    QList<QString> sortedPlugins;

    MobileHotspotConfiguration configuration;

    Enforcement2G3G previousEnforcement;
    QStringList alreadyLoadedModules;
    int scanInterval;
    int apnPowerSave;
    QProcess dnsmasqProcess;
    int ipforward;

    bool showNotifications;
    bool successStarting;

    bool waitingForPreviousConnection;
    QString previousConnectionID;
    QString previousConnectionType;

    bool waitingForAPNs;
    QList<QStringList> availablesAPNs;

protected :
        void closeEvent(QCloseEvent* event);

private slots:
	void configureAccessPoint();
	void configureInternetAccess();
	void doConfigureInternetAccess();
	void configureInterface(int index);
	void pluginTriggered();
	void about();
	void start(bool notification = true);
	void startProcedure();
	void stop(bool notification = true);
	void stopProcedure();
	void previousConnectionSignal(const QDBusMessage &message);
	void availableAPNsSignal(const QDBusMessage &message);
};

#endif // MOBILEHOTSPOTGUI_H
