#include <QtCore/QString>
#include "plugingui.h"
#include "pluginconfiguration.h"


PluginGUI::PluginGUI(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
	ui.lstUA->clear();
	ui.lstUA->addItem(tr("No change"), "nochange");
	ui.lstUA->addItem(tr("MicroB (N900 browser)"), "microb");
	ui.lstUA->addItem(tr("Iphone"), "iphone");
	ui.lstUA->addItem(tr("Custom User-Agent"), "custom");
}

PluginGUI::~PluginGUI()
{

}

void PluginGUI::configuration(PluginConfiguration *conf){
	// Store entered configuration into the configuration object
	// conf->some_variable = ui.some_component->someGetter();
	conf->enabled = ui.chkEnabled->isChecked();
	conf->port = 8118; // not enough space @ screen, maybe in another version ?
	conf->ports = ui.txtPorts->text();
	if(ui.lstUA->currentIndex() == 0)
		conf->ua = UA_NOCHANGE;
	else if(ui.lstUA->currentIndex() == 1)
		conf->ua = UA_MICROB;
	else if(ui.lstUA->currentIndex() == 2)
		conf->ua = UA_IPHONE;
	else
		conf->ua = UA_CUSTOM;
	conf->customUA = ui.txtCustomUA->text();
}

void PluginGUI::setConfiguration(PluginConfiguration &conf){
	// Display configuration from the configuration object
	// ui.some_component->someSetter(conf.some_variable);
	ui.chkEnabled->setChecked(conf.enabled);
	// ui.txtPort->setText(QString::number(conf.port)); // not enough space @ screen, maybe in another version ?
	ui.txtPorts->setText(conf.ports);
	if(conf.ua == UA_NOCHANGE)
		ui.lstUA->setCurrentIndex(0);
	else if(conf.ua == UA_MICROB)
		ui.lstUA->setCurrentIndex(1);
	else if(conf.ua == UA_IPHONE)
		ui.lstUA->setCurrentIndex(2);
	else
		ui.lstUA->setCurrentIndex(3);
	ui.txtCustomUA->setText(conf.customUA);
}

void PluginGUI::reset(){
	ui.chkEnabled->setChecked(false);
	// ui.txtPort->setText("8118"); // not enough space @ screen, maybe in another version ?
	ui.txtPorts->setText("80, 8080");
	ui.lstUA->setCurrentIndex(0);
	ui.txtCustomUA->setText("");
}
