# Include global settings stored in /workspace/qtmobilehotspot/globalsettings.pri
include(../../globalsettings.pri)

# Name of the generated file will be lib$$TARGET.so (ex : libtest.so if TARGET == test)
# Targets should start with qtmh, indicating that they are QtMobileHotspot plugins
# Version info should also be provided
TARGET = qtmhiptablesfix
VERSION = 0.1

# This is a plugin written in QT
CONFIG += qt plugin
TEMPLATE = lib

# We need to enable DBUS
QT += dbus

# Settings are saved using GCONF via a plugin helper
# We need those lines to enable GCONF support
CONFIG += link_pkgconfig
PKGCONFIG += gq-gconf

# Destination folder
# Project organisation : /workspace/qtmobilehotspot/qtMobileHotspot/<plugin_name>[/src/source_files...]
# Executable should be in /workspace/qtmobilehotspot/build/plugins, so ../../build/plugins is good
DESTDIR = ../../build/plugins

# Build folders, should not be changed
# .o files will go in /workspace/qtmobilehotspot/qtMobileHotspot/<plugin_name>/build
# moc files will go in /workspace/qtmobilehotspot/qtMobileHotspot/<plugin_name>/src/.tmp
# ui headers will go in /workspace/qtmobilehotspot/qtMobileHotspot/<plugin_name>/src (same folder as ui cpp/h)
OBJECTS_DIR = build
MOC_DIR = src/.tmp
UI_DIR  = src

# Headers (.h)
# Do not forget to include files from qtMobileHotspot such as mobilehotspotpluginhelper.h, mobilehotspotconfiguration.h, mobilehotspotplugin.h, dbushelper.h
# ../src = the src folder of qtMobileHotspot
# src = the src folder of the plugin
HEADERS = ../src/mobilehotspotpluginhelper.h ../src/mobilehotspotconfiguration.h ../src/mobilehotspotplugin.h	../src/commandhelper.h	../src/dbushelper.h
HEADERS += src/plugin.h	src/pluginconfiguration.h	src/plugingui.h	src/ui_plugingui.h

# Sources (.cpp)
# Do not forget to include files from qtMobileHotspot such as mobilehotspotpluginhelper.cpp, mobilehotspotconfiguration.cpp,	dbushelper.cpp
# ../src = the src folder of qtMobileHotspot
# src = the src folder of the plugin
SOURCES = ../src/mobilehotspotpluginhelper.cpp ../src/mobilehotspotconfiguration.cpp  ../src/commandhelper.cpp	../src/dbushelper.cpp
SOURCES += src/plugin.cpp	src/pluginconfiguration.cpp	src/plugingui.cpp

# Forms (.ui)
# You should not have to put anything from qtMobileHotspot here
# ../src = the src folder of qtMobileHotspot
# src = the src folder of the plugin
FORMS =	src/plugingui.ui

# Translations (.ts)
# Will be called lib$$TARGET-lang.ts (ex : libqtmhdummy-fr.ts)
# TS will be generated by lupdate /path/name-of-pro.pro
# Edit .ts with Qt Linguist, generate .qm (ex : libqtmhdummy-fr.qm)
# Put .qm in data/lang of the plugin
TRANSLATIONS = "lib$$TARGET-fr".ts

# In Eclipse, "clean" removes binaries too
# This is also needed to work around timestamp issues between host and VM in ESbox
# Should not be changed, should work for any DESTDIR and TARGET
QMAKE_CLEAN += "$$DESTDIR/lib$$TARGET".so

# Maemo part (http://wiki.maemo.org/Packaging_a_Qt_application#Creating_a_Maemo_package_from_a_qmake_project)
# Good helpers : source of QCpuFreq and qt-maemo-example
# Should really not be modified at all
unix {
	#VARIABLES
	isEmpty(PREFIX) {
		PREFIX = /usr
	}
	BINDIR = /opt/qtmobilehotspot/plugins
	DATADIR =$$PREFIX/share

	DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

	#MAKE INSTALL

	INSTALLS += target lang util
	target.path =$$BINDIR
	
	lang.path = /opt/qtmobilehotspot/lang
	lang.files += data/lang/*
	
	util.path = /opt/qtmobilehotspot/util
	util.files += data/util/*
}
