#include <QtGui/QCloseEvent>
#include <QtGui/QMenuBar>
#include "plugingui.h"
#include "pluginconfiguration.h"


PluginGUI::PluginGUI(QWidget *parent)
    : QMainWindow(parent)
{
	ui.setupUi(this);
	this->setAttribute(Qt::WA_Maemo5StackedWindow);

	ui.lst2G3G->addItem(tr("No change"), "ignore");
	ui.lst2G3G->addItem(tr("2G only"), "2g");
	ui.lst2G3G->addItem(tr("3G only"), "3g");
	ui.lst2G3G->addItem(tr("2G/3G"), "2g3g");
}

PluginGUI::~PluginGUI()
{

}

void PluginGUI::closeEvent(QCloseEvent* event){
	// Signal that the GUI is closed
	if(menuBar() != 0)
		menuBar()->clear(); // Solves a bug where menubar in child gui is kept in parent gui
	emit windowClosed();
	event->accept();
}

void PluginGUI::configuration(PluginConfiguration *conf){
	// Store entered configuration into the configuration object
	// conf->some_variable = ui.some_component->someGetter();
	conf->disablePowerSaving = ui.chkPowerSaving->isChecked();
	conf->internetPing = ui.chkPing->isChecked();
	conf->internetPingIP = ui.txtPingIP->text();
	conf->wlanCheck = ui.chkWLANCheck->isChecked();

	if(ui.lst2G3G->currentIndex() == 0)
		conf->enforcement2g3g = ENFORCEMENT_2G3G_IGNORE;
	else if(ui.lst2G3G->currentIndex() == 1)
		conf->enforcement2g3g = ENFORCEMENT_2G3G_2G;
	else if(ui.lst2G3G->currentIndex() == 2)
		conf->enforcement2g3g = ENFORCEMENT_2G3G_3G;
	else
		conf->enforcement2g3g = ENFORCEMENT_2G3G_DOUBLE;
}

void PluginGUI::setConfiguration(PluginConfiguration &conf){
	// Display configuration from the configuration object
	// ui.some_component->someSetter(conf.some_variable);
	ui.chkPowerSaving->setChecked(conf.disablePowerSaving);
	ui.chkPing->setChecked(conf.internetPing);
	ui.txtPingIP->setText(conf.internetPingIP);
	ui.chkWLANCheck->setChecked(conf.wlanCheck);

	if(conf.enforcement2g3g == ENFORCEMENT_2G3G_IGNORE)
		ui.lst2G3G->setCurrentIndex(0);
	else if(conf.enforcement2g3g == ENFORCEMENT_2G3G_2G)
		ui.lst2G3G->setCurrentIndex(1);
	else if(conf.enforcement2g3g == ENFORCEMENT_2G3G_3G)
		ui.lst2G3G->setCurrentIndex(2);
	else
		ui.lst2G3G->setCurrentIndex(3);
}

