#include <QtCore/QString>
#include "pluginconfiguration.h"
#include "plugingui2.h"


PluginGUI2::PluginGUI2(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
}

PluginGUI2::~PluginGUI2()
{

}

void PluginGUI2::configuration(PluginConfiguration *conf){
	bool ok;
	conf->port = ui.txtPort->text().toInt(&ok);
	if(! ok)
		conf->port = 8118;
	conf->defaultActions = ui.chkDefaultActions->isChecked();
	conf->forward = ui.chkForward->isChecked();
	conf->forwardIP = ui.txtForwardIP->text().trimmed();
	if(conf->forwardIP == "")
		conf->forwardIP = "127.0.0.1";
	conf->forwardPort = ui.txtForwardPort->text().toInt(&ok);
	if(! ok)
		conf->forwardPort = 10000;
}

void PluginGUI2::setConfiguration(PluginConfiguration &conf){
	ui.txtPort->setText(QString::number(conf.port));
	ui.chkDefaultActions->setChecked(conf.defaultActions);
	ui.chkForward->setChecked(conf.forward);
	ui.txtForwardIP->setText(conf.forwardIP);
	ui.txtForwardPort->setText(QString::number(conf.forwardPort));
}

void PluginGUI2::reset(){
	ui.txtPort->setText("8118");
	ui.chkDefaultActions->setChecked(false);
	ui.chkForward->setChecked(false);
	ui.txtForwardIP->setText("127.0.0.1");
	ui.txtForwardPort->setText("10000");
}
