#include <QtCore/QObject>
#include <QtGui/QMessageBox>
#include <QtCore/qplugin.h>
#include <QtCore/QString>
#include <QtCore/QTranslator>
#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "../../qtMobileHotspot/src/mobilehotspotplugin.h"
#include "../../qtMobileHotspot/src/mobilehotspotconfiguration.h"
#include "pluginconfiguration.h"
#include "plugingui.h"
#include "plugin.h"


Plugin::Plugin(){
	helper = new MobileHotspotPluginHelper(this); // create the helper for this plugin
	conf = new PluginConfiguration(helper); // create the configuration of this plugin
	conf->load(); // load plugin's configuration (see PluginConfiguration::load())
}

Plugin::~Plugin(){
	delete conf; // delete this plugin's configuration
	delete helper; // delete this plugin's helper
	delete translater; // delete this plugin's translator (even if there is no translation)
}

QString Plugin::name(){
	return "org.your_name.qtmh.please.rename.me"; // unique name of the plugin, wont be displayed
}

QString Plugin::displayedName(){
	return tr("Please rename me"); // displayed name in the application menu (if applyable)
}

bool Plugin::displayNameStopped(){
	return false; // get (or not) an entry in the application menu while hotspot is stopped
}

bool Plugin::displayNameRunning(){
	return false; // get (or not) an entry in the application menu while hotspot is active
}

int Plugin::order(){
	// Plugins call ordering
	// Range should be 0..100 (included)
	// Startup calls are done in natural order (0, 1, ..., 100)
	// Shutdown calls are done in reverse order (100, 99, ..., 0)
	// Ranges 0..20 and 80..100 (included) should be reserved to 'official' plugins.
	return 50; // order is not important for Dummy
}

void Plugin::configure(const MobileHotspotConfiguration &configuration, const bool running){
	// Plugin's entry in the application menu has been clicked
	PluginGUI gui; // create the GUI
	gui.setConfiguration(*conf); // load plugin configuration into the GUI
	if(gui.exec() != gui.Accepted) // display the GUI
		return;
	gui.configuration(conf); // get plugin configuration from the GUI
	conf->save(); // save plugin's configuration (see PluginConfiguration::save())
}

void Plugin::beforeStarting(const MobileHotspotConfiguration &configuration){
	// Run before the startup of the hotspot

}

void Plugin::afterStarting(const MobileHotspotConfiguration &configuration, const bool successStarting){
	// Run after the startup of the hotspot

}

void Plugin::beforeStopping(const MobileHotspotConfiguration &configuration, const bool successStarting){
	// Run before the shutdown of the hotspot

}

void Plugin::afterStopping(const MobileHotspotConfiguration & configuration, const bool successStarting, const bool successFinishing){
	// Run after the shutdown of the hotspot

}

QTranslator* Plugin::translator(){
	// Translations need
	// Should be kept as is, even if there are no translations
	return translater;
}

void Plugin::setTranslator(QTranslator *translater){
	// Translations need
	// Should be kept as is, even if there are no translations
	this->translater = translater;
}


Q_EXPORT_PLUGIN2(qtmhdummy, Plugin); // 1st is target name, 2nd is class name
