#ifndef MOBILEHOTSPOTGUIPLUGIN_H
#define MOBILEHOTSPOTGUIPLUGIN_H

#include <QtCore/QString>
#include <QtCore/QTranslator>
#include "mobilehotspotconfiguration.h"


class MobileHotspotPlugin{

public:
	virtual QString name() = 0;
	virtual QString displayedName() = 0;
	virtual bool displayNameStopped() = 0;
	virtual bool displayNameRunning() = 0;
	virtual int order() = 0;

	virtual void configure(const MobileHotspotConfiguration &configuration, const bool running) = 0;
	virtual void beforeStarting(const MobileHotspotConfiguration &configuration) = 0;
	virtual void afterStarting(const MobileHotspotConfiguration &configuration, const bool successStarting) = 0;
	virtual void beforeStopping(const MobileHotspotConfiguration &configuration, const bool successStarting) = 0;
	virtual void afterStopping(const MobileHotspotConfiguration &configuration, const bool successStarting, const bool successFinishing) = 0;

	virtual void setTranslator(QTranslator *translater) = 0;
	virtual QTranslator *translator() = 0;
};

Q_DECLARE_INTERFACE(MobileHotspotPlugin, "com.dest.qtmh.plugin/0.1.1")


#endif // MOBILEHOTSPOTGUIPLUGIN_H
