#ifndef MOBILEHOTSPOTGUI_H
#define MOBILEHOTSPOTGUI_H

#include <QtGui/QMainWindow>
#include <QtCore/QList>
#include <QtCore/QStringList>
#include <QtCore/QString>
#include <QtGui/QCloseEvent>
#include <QtCore/QProcess>
#include <QtCore/QMap>
#include <QtGui/QAction>
#include <QtDBus/QDBusMessage>
#include "dbushelper.h"
#include "mobilehotspotconfiguration.h"
#include "mobilehotspotplugin.h"
#include "ui_mobilehotspotgui.h"


class MobileHotspotGUI : public QMainWindow
{
    Q_OBJECT

public:
    MobileHotspotGUI(QWidget *parent = 0);
    ~MobileHotspotGUI();

private:
	void updateDisplayedConfiguration();
	void loadPlugins();
	void sortPlugins();
	void displayPlugins(bool running);
	void previousConnectionEnableSignal();
	void previousConnectionDisableSignal();
	void previousConnectionRequest();

	Ui::MobileHotspotGUIClass ui;
    QMap<QString, MobileHotspotPlugin*> plugins;
    QList<QString> sortedPlugins;

    MobileHotspotConfiguration configuration;

    Enforcement2G3G previousEnforcement;
    QStringList alreadyLoadedModules;
    int scanInterval;
    QProcess *dnsmasqProcess;
    int ipforward;

    bool showNotifications;
    bool successStarting;

    bool waitingForPreviousConnection;
    QString previousConnectionID;
    QString previousConnectionType;

protected :
        void closeEvent(QCloseEvent* event);

private slots:
	void usbWindowsAssistant();
	void configureAccessPoint();
	void configureInternetAccess();
	void configureInterface(int index);
	void pluginTriggered();
	void start(bool notification = true);
	void startProcedure();
	void stop(bool notification = true);
	void stopProcedure();
	void bypassUSBModeWindow();
	void previousConnectionSignal(const QDBusMessage &message);
};

#endif // MOBILEHOTSPOTGUI_H
