#include <QtCore/QString>
#include "plugingui2.h"
#include "pluginconfiguration.h"
#include "plugingui.h"


PluginGUI::PluginGUI(QWidget *parent)
    : QDialog(parent)
{
	advancedConf = new PluginConfiguration();
	ui.setupUi(this);
	ui.lstUA->clear();
	ui.lstUA->addItem(tr("No change"), "nochange");
	ui.lstUA->addItem(tr("MicroB (N900 browser)"), "microb");
	ui.lstUA->addItem(tr("Iphone"), "iphone");
	ui.lstUA->addItem(tr("Custom User-Agent"), "custom");
}

PluginGUI::~PluginGUI()
{
	delete advancedConf;
}

void PluginGUI::configuration(PluginConfiguration *conf){
	// Store entered configuration into the configuration object
	// conf->some_variable = ui.some_component->someGetter();
	conf->enabled = ui.chkEnabled->isChecked();
	conf->port = 8118;
	conf->ports = ui.txtPorts->text();
	if(ui.lstUA->currentIndex() == 0)
		conf->ua = UA_NOCHANGE;
	else if(ui.lstUA->currentIndex() == 1)
		conf->ua = UA_MICROB;
	else if(ui.lstUA->currentIndex() == 2)
		conf->ua = UA_IPHONE;
	else
		conf->ua = UA_CUSTOM;
	conf->customUA = ui.txtCustomUA->text();

	conf->port = advancedConf->port;
	conf->defaultActions = advancedConf->defaultActions;
	conf->forward = advancedConf->forward;
	conf->forwardIP = advancedConf->forwardIP;
	conf->forwardPort = advancedConf->forwardPort;
}

void PluginGUI::setConfiguration(PluginConfiguration &conf){
	// Display configuration from the configuration object
	// ui.some_component->someSetter(conf.some_variable);

	ui.chkEnabled->setChecked(conf.enabled);
	ui.txtPorts->setText(conf.ports);
	if(conf.ua == UA_NOCHANGE)
		ui.lstUA->setCurrentIndex(0);
	else if(conf.ua == UA_MICROB)
		ui.lstUA->setCurrentIndex(1);
	else if(conf.ua == UA_IPHONE)
		ui.lstUA->setCurrentIndex(2);
	else
		ui.lstUA->setCurrentIndex(3);
	ui.txtCustomUA->setText(conf.customUA);

	advancedConf->port = conf.port;
	advancedConf->defaultActions = conf.defaultActions;
	advancedConf->forward = conf.forward;
	advancedConf->forwardIP = conf.forwardIP;
	advancedConf->forwardPort = conf.forwardPort;
}

void PluginGUI::reset(){
	ui.chkEnabled->setChecked(false);
	ui.txtPorts->setText("80, 8080");
	ui.lstUA->setCurrentIndex(0);
	ui.txtCustomUA->setText("");
}

void PluginGUI::advanced(){
	PluginGUI2 gui;
	PluginConfiguration conf = *advancedConf;
	gui.setConfiguration(conf);
	if(gui.exec() != gui.Accepted)
		return;
	gui.configuration(advancedConf);
}


