#include "plugingui.h"
#include "pluginconfiguration.h"


PluginGUI::PluginGUI(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
}

PluginGUI::~PluginGUI()
{

}

void PluginGUI::configuration(PluginConfiguration *conf){
	// Store entered configuration into the configuration object
	// conf->some_variable = ui.some_component->someGetter();
	conf->disablePowerSaving = ui.chkPowerSaving->isChecked();
	conf->internetPing = ui.chkPing->isChecked();
	conf->internetPingIP = ui.txtPingIP->text();
}

void PluginGUI::setConfiguration(PluginConfiguration &conf){
	// Display configuration from the configuration object
	// ui.some_component->someSetter(conf.some_variable);
	ui.chkPowerSaving->setChecked(conf.disablePowerSaving);
	ui.chkPing->setChecked(conf.internetPing);
	ui.txtPingIP->setText(conf.internetPingIP);
}

void PluginGUI::reset(){
	ui.chkPowerSaving->setChecked(false);
	ui.chkPing->setChecked(false);
	ui.txtPingIP->setText("example.com");
}
