#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QStringListIterator>
#include <QtCore/QProcess>
#include <QtCore/QFile>
#include "../../qtMobileHotspot/src/mobilehotspotconfiguration.h"
#include "../../qtMobileHotspot/src/commandhelper.h"
#include "pluginconfiguration.h"
#include "privoxyhelper.h"


PrivoxyHelper::PrivoxyHelper(){
}

PrivoxyHelper::~PrivoxyHelper(){
}

int PrivoxyHelper::generateConfigurationFile(const MobileHotspotConfiguration &configuration, PluginConfiguration *conf){
	/* 0=ok, -1=fail */
	int ret;
	QString cmd("cat ");
	cmd += (QString(CONFIGURATION_FILE_QTMH) + " > ") + CONFIGURATION_FILE;
	CommandHelper::executeCommandOld(cmd, &ret);
	if(ret != 0){
		qDebug("FAILURE : Cannot copy our privoxy sample configuration");
		return -1;
	}

	cmd = ((QString("echo \"listen-address ") + configuration.lanNetwork) + "1:") + QString::number(conf->port) + "\"";
	cmd += QString(" >> ") + CONFIGURATION_FILE;
	CommandHelper::executeCommandOld(cmd, &ret);
	if(ret != 0){
		qDebug("FAILURE : Cannot append our settings to the privoxy configuration file");
		return -1;
	}
	return 0;
}

int PrivoxyHelper::deleteConfigurationFile(const MobileHotspotConfiguration &configuration, PluginConfiguration *conf){
	/* 0=ok, -1=fail */
	QFile file(CONFIGURATION_FILE);
	if(file.exists())
		return file.remove() ? 0 : 1;
	return 0;
}

int PrivoxyHelper::generateActionFile(const MobileHotspotConfiguration &configuration, PluginConfiguration *conf){
	/* 0=ok, -1=fail */
	int ret;
	QString cmd("cat ");
	cmd += (QString(ACTION_FILE_QTMH) + " > ") + ACTION_FILE;
	CommandHelper::executeCommandOld(cmd, &ret);
	if(ret != 0){
		qDebug("FAILURE : Cannot copy our privoxy action file");
		return -1;
	}

	if(conf->ua != UA_NOCHANGE){
		cmd = QString("echo \"{ +hide-user-agent{");
		if(conf->ua == UA_MICROB)
			cmd += MICROB;
		else if(conf->ua == UA_IPHONE)
			cmd += IPHONE;
		else
			cmd += conf->customUA;
		cmd += "} }";
		cmd += QString("\" >> ") + ACTION_FILE;
		CommandHelper::executeCommandOld(cmd, &ret);
		if(ret != 0){
			qDebug("FAILURE : Cannot append our settings to the privoxy configuration file");
			return -1;
		}
		cmd = QString("echo \"/ # All websites\" >> ") + ACTION_FILE;
		CommandHelper::executeCommandOld(cmd, &ret);
		if(ret != 0){
			qDebug("FAILURE : Cannot append our settings to the privoxy configuration file");
			return -1;
		}
	}
	return 0;
}

int PrivoxyHelper::deleteActionFile(const MobileHotspotConfiguration &configuration, PluginConfiguration *conf){
	/* 0=ok, -1=fail */
	QFile file(ACTION_FILE);
	if(file.exists())
		return file.remove() ? 0 : 1;
	return 0;
}

int PrivoxyHelper::runPrivoxy(const MobileHotspotConfiguration &configuration, PluginConfiguration *conf, QProcess *process){
	/* 0=ok, -1=fail */
	QString cmd = (QString(PRIVOXY_FILE) + " --no-daemon --user user.users ") + CONFIGURATION_FILE;
	bool ret = CommandHelper::executeCommandAsync(cmd, process, 5000);
	return ret ? 0 : -1;
}

int PrivoxyHelper::stopPrivoxy(const MobileHotspotConfiguration &configuration, PluginConfiguration *conf, QProcess *process){
	/* 0=ok, -1=fail */
	process->terminate();
	return process->waitForFinished(5000) ? 0 : 1;
}

int PrivoxyHelper::setIptables(const MobileHotspotConfiguration &configuration, PluginConfiguration *conf){
	/* 0=ok, -1=fail */
	QStringList commands; // $IPTABLES -t nat -A PREROUTING -i $LANIF -s $LANNET -d ! $LANNET -p tcp --dport $PORT -j REDIRECT --to-port 8118
	QString baseCmd("/usr/sbin/iptables -t nat -A PREROUTING");
	baseCmd += QString(" -i ") + configuration.lanInterface;
	baseCmd += (QString(" -s ") + configuration.lanNetwork) + "0/24";
	baseCmd += (QString(" -d ! ") + configuration.lanNetwork) + "0/24";
	baseCmd += " -p tcp --dport";

	QStringList ports;
	ports = conf->ports.split(",");
	QStringListIterator iterator(ports);
	while(iterator.hasNext()){
		QString port = iterator.next().trimmed();
		QString cmd = (baseCmd + QString(" ")) + port;
		cmd += QString(" -j REDIRECT --to-port ") + QString::number(conf->port);
		commands.append(cmd);
	}

	iterator = QStringListIterator(commands);
	while(iterator.hasNext()){
		QString cmd = iterator.next();
		int ret;
		bool res = CommandHelper::executeCommand(cmd, &ret);
		if(ret != 0 || res == false){
			qDebug("FAILURE : Last command generated an error - exiting iptables for privoxy");
			return -1;
		}
	}
	return 0;
}
