#ifndef PLUGINGUI_H
#define PLUGINGUI_H

#include <QtGui/QDialog>
#include <QtGui/QCheckBox>
#include <QtCore/QString>
#include "ui_plugingui.h"
#include "pluginconfiguration.h"


class PluginGUI : public QDialog
{
    Q_OBJECT

public:
    PluginGUI(QWidget *parent = 0);
    ~PluginGUI();
    void configuration(PluginConfiguration *conf);
    void setConfiguration(PluginConfiguration &conf);

private:
    Ui::PluginGUIClass ui;
    QCheckBox *lastClickedMac;
    bool isValidMAC(QString name, QString mac);

private slots:
	void addMac();
	void removeMac();
	void enableAll();
	void disableAll();
	void reset();
	void macClicked();
};

#endif // PLUGINGUI_H
