#include "plugingui.h"
#include "pluginconfiguration.h"


PluginGUI::PluginGUI(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
}

PluginGUI::~PluginGUI()
{

}

void PluginGUI::configuration(PluginConfiguration *conf){
	// Store entered configuration into the configuration object
	// conf->some_variable = ui.some_component->someGetter();
	conf->list = ui.txtIptables->toPlainText().trimmed().split("\n");
}

void PluginGUI::setConfiguration(PluginConfiguration &conf){
	// Display configuration from the configuration object
	// ui.some_component->someSetter(conf.some_variable);
	ui.txtIptables->setPlainText(conf.list.join("\n"));
}

void PluginGUI::defaultIptables(){
	ui.txtIptables->setPlainText(PluginConfiguration::defaultIptables);
}
