#ifndef PLUGIN_H
#define PLUGIN_H

#include <QtCore/QObject>
#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "../../qtMobileHotspot/src/mobilehotspotplugin.h"
#include "../../qtMobileHotspot/src/mobilehotspotconfiguration.h"
#include "pluginconfiguration.h"


class Plugin : public QObject, public MobileHotspotPlugin{

	Q_OBJECT
	Q_INTERFACES(MobileHotspotPlugin)

public:
	Plugin();
	~Plugin();
	QString name();
	QString displayedName();
	bool displayName();
	int order();

	void configure(const MobileHotspotConfiguration &configuration, const bool running);
	void beforeStarting(const MobileHotspotConfiguration &configuration);
	void afterStarting(const MobileHotspotConfiguration &configuration, const bool successStarting);
	void beforeStopping(const MobileHotspotConfiguration &configuration, const bool successStarting);
	void afterStopping(const MobileHotspotConfiguration &configuration, const bool successStarting, const bool successFinishing);

	void setTranslator(QTranslator *translater);
	QTranslator *translator();

private:
	MobileHotspotPluginHelper *helper; // Helper for this plugin
	PluginConfiguration *conf; // Configuration of this plugin
	QTranslator *translater; // Translator of this plugin (even if there are no translations)
	QString lanMac(const MobileHotspotConfiguration &configuration);
};


#endif // PLUGIN_H
