#include <QtCore/QString>
#include <QtCore/QList>
#include <QtCore/QStringList>
#include <gq/gconfitem.h>
#include "apnhelper.h"


APNHelper::APNHelper(){

}

APNHelper::~APNHelper(){

}

QList<QStringList> APNHelper::apnList(){
	QList<QStringList> list;
	GConfItem listroot(GCONF_APN_LIST);
	QList<QString> apns = listroot.listDirs();
	for(int i = 0; i < apns.size(); i++){
		QString apnkey = apns.at(i);
		QString apid = apnkey.right(apnkey.size() - apnkey.lastIndexOf('/') - 1).replace("@32@", " ");
		GConfItem apnType(apnkey + GCONF_APN_TYPE);
		if(apnType.value("?").toString() == GCONF_APN_TYPE_GPRS){
			GConfItem apnName(apnkey + GCONF_APN_NAME);
			QString name = apnName.value("?").toString();
			if(name != "?"){
				QStringList sublist;
				sublist.append(name);
				sublist.append(apid);
				list.append(sublist);
				qDebug( (QString("APN found : ") + name + " :: " + apid).toAscii().data() );
			}
		}
	}
	return list;
}

void APNHelper::setScanInterval(int newValue, int *oldValue){
	GConfItem item(GCONF_SCANINTERVAL);
	bool ok;
	int ret;
	ret = item.value(300).toInt(&ok); // 300 = 5 minutes, shouldnt be used anyway
	if(! ok)
		ret = 300;
	*oldValue = ret;
	item.set(newValue);
	qDebug( (QString("Set scan interval from ") + QString::number(ret) + " to " + QString::number(newValue)).toAscii().data() );

}

