#include <QtCore/QObject>
#include <QtGui/QMessageBox>
#include <QtCore/qplugin.h>
#include <QtCore/QString>
#include <QtCore/QTranslator>
#include "../../src/mobilehotspotpluginhelper.h"
#include "../../src/mobilehotspotplugin.h"
#include "../../src/mobilehotspotconfiguration.h"
#include "../../src/commandhelper.h"
#include "pluginconfiguration.h"
#include "plugingui.h"
#include "plugin.h"


Plugin::Plugin(){
	helper = new MobileHotspotPluginHelper(this); // create the helper for this plugin
	conf = new PluginConfiguration(helper); // create the configuration of this plugin
	conf->load(); // load plugin's configuration (see PluginConfiguration::load())
}

Plugin::~Plugin(){
	delete conf; // delete this plugin's configuration
	delete helper; // delete this plugin's helper
	delete translater; // delete this plugin's translator (even if there is no translation)
}

QString Plugin::name(){
	return "com.dest.qtmh.macfilter"; // unique name of the plugin, wont be displayed
}

QString Plugin::displayedName(){
	return tr("MAC Filter"); // displayed name in the application menu (if applyable)
}

bool Plugin::displayName(){
	return true; // get (or not) an entry in the application menu
}

int Plugin::order(){
	// Plugins call ordering
	// Range should be 0..100 (included)
	// Startup calls are done in natural order (0, 1, ..., 100)
	// Shutdown calls are done in reverse order (100, 99, ..., 0)
	// Ranges 0..20 and 80..100 (included) should be reserved to 'official' plugins.
	return 5; // MAC filtering is important and should be setup first
}

void Plugin::configure(const MobileHotspotConfiguration &configuration, const bool running){
	// Plugin's entry in the application menu has been clicked
	PluginGUI gui; // create the GUI
	gui.setConfiguration(*conf); // load plugin configuration into the GUI
	if(gui.exec() != gui.Accepted) // display the GUI
		return;
	gui.configuration(conf); // get plugin configuration from the GUI
	conf->save(); // save plugin's configuration (see PluginConfiguration::save())
	if(running)
		whileRunning(configuration);
}

void Plugin::beforeStarting(const MobileHotspotConfiguration &configuration){
	// Run before the startup of the hotspot

}

void Plugin::whileRunning(const MobileHotspotConfiguration &configuration){
	if(configuration.interface != configuration.INTERFACE_WLAN)
		return;
	QStringList commands;
	commands.append("/usr/sbin/iptables -F MACFILTER_IF");
	appendFilteringCommands(configuration, &commands);
	executeCommands(&commands);
}

void Plugin::afterStarting(const MobileHotspotConfiguration &configuration, const bool successStarting){
	// Run after the startup of the hotspot
	if( (! successStarting) || (configuration.interface != configuration.INTERFACE_WLAN) )
		return;
	QStringList commands;
	commands.append("/usr/sbin/iptables -N MACFILTER_IF");
	appendFilteringCommands(configuration, &commands);
	commands.append("/usr/sbin/iptables -A INPUT -i " + configuration.interface + " -j MACFILTER_IF");
	commands.append("/usr/sbin/iptables -A FORWARD -i " + configuration.interface + " -j MACFILTER_IF");
	executeCommands(&commands);
}

void Plugin::beforeStopping(const MobileHotspotConfiguration &configuration, const bool successStarting){
	// Run before the shutdown of the hotspot

}

void Plugin::afterStopping(const MobileHotspotConfiguration & configuration, const bool successStarting, const bool successFinishing){
	// Run after the shutdown of the hotspot

}

void Plugin::appendFilteringCommands(const MobileHotspotConfiguration &configuration, QStringList *commands){
	QStringList macs;
	QStringListIterator iterator(conf->mactable);
	while(iterator.hasNext()){
		QString entry = iterator.next();
		QStringList split = entry.split("/");
		if(split.value(0) == "yes")
			macs.append(split.value(2));
	}

	iterator = QStringListIterator(macs);
	if(conf->filterMode == MODE_ALLOW){
		while(iterator.hasNext()){
			QString mac = iterator.next();
			commands->append("/usr/sbin/iptables -A MACFILTER_IF -m mac --mac-source " + mac + " -j RETURN");
		}
		commands->append("/usr/sbin/iptables -A MACFILTER_IF -j DROP");
	}
	else if(conf->filterMode == MODE_DENY){
		while(iterator.hasNext()){
			QString mac = iterator.next();
			commands->append("/usr/sbin/iptables -A MACFILTER_IF -m mac --mac-source " + mac + " -j DROP");
		}
	}
}

void Plugin::executeCommands(QStringList *commands){
	QStringListIterator iterator = QStringListIterator(*commands);
	while(iterator.hasNext()){
		QString cmd = iterator.next();
		bool res; int ret;
		res = CommandHelper::executeCommand(cmd, &ret);
		if( (! res) || ret != 0)
			qDebug("MACFILTER : WARNING : Last command failed");
	}
}

QTranslator* Plugin::translator(){
	// Translations need
	// Should be kept as is, even if there are no translations
	return translater;
}

void Plugin::setTranslator(QTranslator *translater){
	// Translations need
	// Should be kept as is, even if there are no translations
	this->translater = translater;
}


Q_EXPORT_PLUGIN2(qtmhmacfilter, Plugin); // 1st is target name, 2nd is class name
