/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QPropertyAnimation>
#include <QDebug>

#include "scrollbar.h"
#include "pixmaploader.h"

ScrollBar::ScrollBar(QGraphicsItem* parent)
    : QGraphicsPixmapItem(PixmapLoader::getPic("scroll"), parent)
    , m_knob(PixmapLoader::getPic("scroll_knob"), this)
    , m_height(pixmap().height() - m_knob.pixmap().height())
    , m_value(0.0)
    , m_visible(false)
{
    hide();
    setOpacity(0.0);
    m_knob.setPos(0.0, 0.0);
    m_timer.setSingleShot(true);
    m_timer.setInterval(1000);

    connect(&m_timer, SIGNAL(timeout()), this, SLOT(timeout()));
}

int ScrollBar::loadImages()
{
    PixmapLoader::load("scroll");
    PixmapLoader::load("scroll_knob");
    return 2;
}
bool ScrollBar::startAnimation(bool show)
{
    if (show == m_visible)
        return false;

    m_visible = show;
    m_timer.stop();

    if (m_animation)
        m_animation->stop();

    QPropertyAnimation* animation = new QPropertyAnimation(this, "opacity");
    animation->setEasingCurve(QEasingCurve::OutExpo);
    animation->setDuration(500);
    animation->setEndValue(show ? 1.0 : 0.0);

    if (show)
        connect(animation, SIGNAL(finished()), &m_timer, SLOT(start()));
    else
        connect(animation, SIGNAL(finished()), this, SLOT(hideScrollBar()));

    m_animation = animation;
    animation->start(QAbstractAnimation::DeleteWhenStopped);
    return true;
}

void ScrollBar::setValue(qreal value)
{
    if (value < 0 || value > 1.0)
        return;
    m_value = value;
    m_knob.setPos(0, m_value * m_height);

    show();
    if (!startAnimation(true))
        m_timer.start();
}




