#ifndef FAKECONTENTSCREEN_H
#define FAKECONTENTSCREEN_H

#include <QObject>
#include <QGraphicsItem>

class FakeContentScreen : public QObject, public QGraphicsItem
{
    Q_OBJECT
    Q_INTERFACES(QGraphicsItem)
public:
    FakeContentScreen(QGraphicsItem *parent = 0);
    static int loadImages();

    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

private:
    const QRectF m_boundingRect;
    QPixmap m_left;
    QPixmap m_right;

signals:
    void userAccepted();
};

#endif // FAKECONTENTSCREEN_H
