/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QBrush>
#include <QEvent>
#include <QPointF>
#include <QGraphicsPixmapItem>

#include "popup.h"
#include "designinformation.h"

// PopupCloseButton

PopupCloseButton::PopupCloseButton(QGraphicsItem *parent)
        : QGraphicsPixmapItem(parent)
{
    setShapeMode(BoundingRectShape);
}

QPainterPath PopupCloseButton::shape() const
{
    return QGraphicsItem::shape();
}

QRectF PopupCloseButton::boundingRect() const
{
    static const qreal minSize = 80.0;
    QRectF result(QGraphicsPixmapItem::boundingRect());
    qreal hMargin = minSize < result.width() ? 0 : (minSize - result.width()) / 2;
    qreal vMargin = minSize < result.height() ? 0 : (minSize - result.height()) / 2;
    result.adjust(-hMargin, -vMargin, hMargin, vMargin);
    return result;
}

// PopUp

PopUp::PopUp(QGraphicsItem* parent)
    : QGraphicsRectItem(parent)
{
    m_allDone = new QGraphicsPixmapItem(this);
    m_allDone->installSceneEventFilter(this);

    m_startAgain = new QGraphicsPixmapItem(m_allDone);
    m_startAgain->installSceneEventFilter(this);

    m_close = new PopupCloseButton(m_allDone);
    m_close->installSceneEventFilter(this);

    updateUI();
}

void PopUp::updateUI()
{
    m_allDone->setPixmap(DesignInformation::getPixmap("alldone.background"));
    m_allDone->setPos((parentItem()->boundingRect().bottomRight()/2) -
            (m_allDone->boundingRect().bottomRight()/2));

    m_startAgain->setPixmap(DesignInformation::getPixmap("alldone.startagain_off"));
    m_startAgain->setPos((m_allDone->boundingRect().bottomRight()/2) -
            (m_startAgain->boundingRect().bottomRight()/2) +
            DesignInformation::getPosition("alldone.startagain_off"));

    m_close->setPixmap(DesignInformation::getPixmap("alldone.close_button"));
    m_close->setPos((m_allDone->boundingRect().bottomRight()/2) -
            (m_close->boundingRect().bottomRight()/2) +
    DesignInformation::getPosition("alldone.close_button"));
}

bool PopUp::sceneEventFilter(QGraphicsItem *item, QEvent *event)
{
    if ((event->type() == QEvent::GraphicsSceneMousePress) and (item == m_startAgain))
        emit listStartAgain();
    else if ((event->type() == QEvent::GraphicsSceneMousePress) and (item == m_close))
        emit deletePopUp();
    return true;
}
