/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef _MAINCONTAINER_H_
#define _MAINCONTAINER_H_

#include <QPointF>
#include <QObject>
#include <QKeyEvent>
#include <QAbstractAnimation>
#include <QPropertyAnimation>

#include <QGraphicsRectItem>
#include <QGraphicsPixmapItem>

#include "shoppinglistcategoryui.h"
#include "gesturebox.h"

class CloseButton: public QGraphicsPixmapItem
{
public:
    CloseButton(QGraphicsItem *parent = 0);
    QRectF boundingRect() const;
    QPainterPath shape() const;
    void updateUI();
protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
};

class ListChangeGestureBox : public QObject, public GestureBox
{
    Q_OBJECT
public:
    ListChangeGestureBox(QGraphicsItem *parent = 0);
    void setActivate(bool active);

signals:
    void moveLeft();
    void moveRight();

protected:
    void gestureMousePress(QPointF pos, bool &startGesture, bool &acceptClick);
    void gestureStart(QPointF pos);
    void gestureMove(QPointF pos, QPointF movement, QPointF speed);
    void gestureEnd(QPointF pos, QPointF speed);

private:
    bool m_active;
    QPointF m_startPoint;
    QTime m_startTime;
};

class MainContainer: public QObject, public QGraphicsPixmapItem
{
    Q_OBJECT
    Q_PROPERTY(QPointF position READ position WRITE setPosition);

public:
    MainContainer();
    virtual ~MainContainer() {};

    void add(ShoppingListCategoryUI *);

    void updateUI();



public slots:
    void moveLeft();
    void moveRight();

private slots:
    void animationFinished();

private:
    QPointF position() { return m_hold->pos(); }
    void setPosition(QPointF pos) { m_hold->setPos(pos); }

    QAbstractAnimation* m_animation;
    QAbstractAnimation* sideAnimation(bool leftToRight);

    QList<ShoppingListCategoryUI*> m_lists;
    int m_current;
    QGraphicsRectItem* m_hold;
    CloseButton *m_closeButton;
    ListChangeGestureBox *m_gestureBox;
    QGraphicsTextItem* m_title;

    void adjustGestureBox();
    void startMovement(bool leftToRight);
    void adjustListsPositions();
};

#endif /* _MAINCONTAINER_H_ */
